/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console;

import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import jeus.jms.console.command.JMSClusterCommand;
import jeus.jms.console.command.JMSConfAllCommand;
import jeus.jms.console.command.JMSConfCommand;
import jeus.jms.console.command.JMSCreateConfCommand;
import jeus.jms.console.command.JMSCreateDestCommand;
import jeus.jms.console.command.JMSDestAllCommand;
import jeus.jms.console.command.JMSDestCommand;
import jeus.jms.console.command.JMSDurableAllCommand;
import jeus.jms.console.command.JMSDurableCommand;
import jeus.jms.console.command.JMSEntryAllCommand;
import jeus.jms.console.command.JMSEntryCommand;
import jeus.jms.console.command.JMSRemoveConfCommand;
import jeus.jms.console.command.JMSRemoveDestCommand;
import jeus.jms.console.command.JMSRestatCommand;
import jeus.jms.console.command.JMSServerCommand;
import jeus.jms.console.command.JMSStatCommand;
import jeus.jms.console.command.JMSStorageDebugCommand;
import jeus.jms.console.command.JMSTakeoverCommand;
import jeus.management.enterprise.agent.JmxMPMBeanServerChecker;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Command;
import jeus.util.console.command.MBeanListCommand;
import jeus.util.properties.JeusNetPropertyValues;

public class JMSConsole
extends AbstractConsoleUtil {
    private static String container;
    private static MBeanServerConnection utility;
    private boolean forStandalone;
    private String standaloneAddress;
    private int port;

    public static void main(String[] args) {
        JMSConsole util = new JMSConsole();
        util.mainMethod(args);
    }

    protected void registerCommands() {
        this.registerCommand((Command)new JMSServerCommand(this, container, utility));
        this.registerCommand((Command)new JMSDestAllCommand(this, container, utility));
        this.registerCommand((Command)new JMSDestCommand(this, container, utility));
        this.registerCommand((Command)new JMSCreateDestCommand(this, container, utility));
        this.registerCommand((Command)new JMSRemoveDestCommand(this, container, utility));
        this.registerCommand((Command)new JMSConfAllCommand(this, container, utility));
        this.registerCommand((Command)new JMSConfCommand(this, container, utility));
        this.registerCommand((Command)new JMSCreateConfCommand(this, container, utility));
        this.registerCommand((Command)new JMSRemoveConfCommand(this, container, utility));
        this.registerCommand((Command)new JMSEntryAllCommand(this, container, utility));
        this.registerCommand((Command)new JMSEntryCommand(this, container, utility));
        this.registerCommand((Command)new JMSDurableAllCommand(this, container, utility));
        this.registerCommand((Command)new JMSDurableCommand(this, container, utility));
        this.registerCommand((Command)new JMSClusterCommand(this, container, utility));
        this.registerCommand((Command)new JMSTakeoverCommand(this, container, utility));
        this.registerCommand((Command)new MBeanListCommand(utility));
        this.registerCommand((Command)new JMSStatCommand(this, container, utility));
        this.registerCommand((Command)new JMSRestatCommand(this, container, utility));
        this.registerCommand((Command)new JMSStorageDebugCommand(this, container, utility));
    }

    protected void printCommandHelp() {
        out.println(" Usage:" + StringUtil.lineSeparator + "       jmsadmin  [-h] [-verbose] engine_container_name" + StringUtil.lineSeparator + "                 [-U<username>] [-P<password>] [-f<filename>]" + StringUtil.lineSeparator + "                 [command] [command_options]" + StringUtil.lineSeparator);
    }

    protected String getPrompt() {
        return this.forStandalone ? "embedded" : container;
    }

    protected String getWelcomeMessage() {
        return "JMS Engine Administration";
    }

    protected MBeanServerConnection initializeConnection() throws Exception {
        if (this.forStandalone) {
            JMXServiceURL url = !doNotUseSecurity ? new JMXServiceURL("jmxmp", this.standaloneAddress, this.port, "/JMX") : new JMXServiceURL("jmxmp", this.standaloneAddress, this.port);
            HashMap<String, JMXServiceURL> services = new HashMap<String, JMXServiceURL>();
            services.put("embedded", url);
            Hashtable<Object, HashMap<String, JMXServiceURL>> env = new Hashtable<Object, HashMap<String, JMXServiceURL>>();
            env.put(JmxMPMBeanServerChecker.JMXServiceURL_KEY, services);
            utility = MEJBUtility.getMEJBUtility(env);
        } else {
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
                env.put("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
                env.put("java.naming.provider.url", StringUtil.getNodeNameFromContainerName((String)container));
                utility = MEJBUtility.getMEJBUtility(env);
            }
            catch (Exception ex) {
                throw new JeusRuntimeException("fail to get remote JMX connector", (Throwable)ex);
            }
        }
        return utility;
    }

    protected ObjectName getTargetObjectName() throws Exception {
        String query = "JEUS:j2eeType=JMSResource" + (this.forStandalone ? "" : ",J2EEServer=" + container) + ",*";
        return new ObjectName(query);
    }

    protected String[] processCmdArgs(String[] args) throws Exception {
        if (args.length >= 1) {
            if (args[0].equals("-s")) {
                this.forStandalone = true;
                if (args.length >= 2 && !args[1].startsWith("-")) {
                    this.standaloneAddress = args[1];
                    int index = this.standaloneAddress.indexOf(":");
                    if (index >= 0) {
                        this.port = Integer.parseInt(this.standaloneAddress.substring(index + 1)) + 1;
                        this.standaloneAddress = index == 0 ? JeusNetPropertyValues.LOCAL_HOSTADDRESS : this.standaloneAddress.substring(0, index);
                    } else {
                        this.port = 9742;
                    }
                    this.nodeName = this.standaloneAddress + ":" + this.port;
                    return JMSConsole.removeElements((String[])args, (int[])new int[]{0, 1});
                }
                this.standaloneAddress = JeusNetPropertyValues.LOCAL_HOSTADDRESS;
                this.port = 9742;
                this.nodeName = this.standaloneAddress + ":" + this.port;
                return JMSConsole.removeElements((String[])args);
            }
            container = args[0];
            this.nodeName = StringUtil.getNodeNameFromContainerName((String)container);
            this.realNodeName = VirtualDNS.getRealNodeName((String)this.nodeName);
            return JMSConsole.removeElements((String[])args);
        }
        throw new JeusRuntimeException("jmsadmin <nodeName>_<containerName>");
    }

    public String getConsoleName() {
        return "JMSAdmin";
    }
}

