/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import jeus.jms.common.message.MessageInfo;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.management.JMXUtility;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.command.MBeanCommand;

public abstract class JMSCommand
extends MBeanCommand {
    protected static final String leftBrace = "====<<";
    protected static final String rightBrace = ">>====";
    protected String container;
    protected AbstractConsoleUtil console;

    public JMSCommand(AbstractConsoleUtil console, String s, String s1, MBeanServerConnection mBeanServerConnection, String container) {
        super(s, s1, mBeanServerConnection);
        this.console = console;
        this.container = container;
    }

    protected void directLogWithSpace(String log, PrintStream out) {
        out.println("  " + log);
    }

    protected JMSResourceMBean getJMSResourceMBean() throws IOException, IllegalJeusSystemNameException {
        ObjectName jmsResource = JMXUtility.queryJMSResource((MBeanServerConnection)this.utility, (String)this.container, null, (String)"JMSResource", null);
        return (JMSResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.utility, (ObjectName)jmsResource, JMSResourceMBean.class, (boolean)false);
    }

    protected void showDestination(List destNames, boolean showInfo, PrintStream out) {
        if (destNames == null || destNames.isEmpty()) {
            this.directLogWithSpace("There is no destination", out);
            return;
        }
        if (showInfo) {
            out.println("====<<Destination>>====");
        }
        this.printSortedName(destNames, out);
    }

    public static Object newProxyInstance(MBeanServerConnection mbeanserverconnection, ObjectName objectname, Class class1, Class class2, boolean flag) {
        MBeanServerInvocationHandler mbeanserverinvocationhandler = new MBeanServerInvocationHandler(mbeanserverconnection, objectname);
        Class[] aclass = flag ? new Class[]{class1, class2, NotificationEmitter.class} : new Class[]{class1, class2};
        return Proxy.newProxyInstance(class1.getClassLoader(), aclass, (InvocationHandler)mbeanserverinvocationhandler);
    }

    public void showMessageInfo(List messageInfos, PrintStream out) {
        this.directLogWithSpace("\tMessage:", out);
        for (int i = 0; i < messageInfos.size(); ++i) {
            MessageInfo info = (MessageInfo)messageInfos.get(i);
            this.directLogWithSpace("\tMessage ID: " + info.messageID, out);
            this.directLogWithSpace("\tMessage Type: " + info.getMessageType(), out);
            this.directLogWithSpace("\tDelivered: " + info.delivered, out);
            this.directLogWithSpace("\tCreate time: " + logformat.format(new Date(info.createdTime)), out);
        }
    }

    protected void printSortedName(List _confAll, PrintStream out) {
        Object[] modules = JMXUtility.getNameStringArray((ObjectName[])_confAll.toArray(new ObjectName[_confAll.size()]));
        Arrays.sort(modules);
        for (int i = 0; i < modules.length; ++i) {
            try {
                this.directLogWithSpace((String)modules[i], out);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void printSortedName(String[] _entryAll, PrintStream out) {
        Object[] modules;
        try {
            modules = JMXUtility.getNameStringArray((String[])_entryAll);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        Arrays.sort(modules);
        for (int i = 0; i < modules.length; ++i) {
            try {
                this.directLogWithSpace((String)modules[i], out);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

