/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.PrintStream;
import java.util.Arrays;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.jms.console.command.JMSCommand;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;

public class JMSDurableAllCommand
extends JMSCommand {
    public JMSDurableAllCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "durableall", "lists all durable subscriptions", utility, container);
    }

    public void run(PrintStream out) throws Exception {
        out.println("====<<Durable Subscription>>====");
        ObjectName[] names = JMXUtility.findJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSDurableSubscriberResource", null);
        if (names == null) {
            this.directLogWithSpace("<No Durable Subscription found>", out);
            return;
        }
        Object[] modules = JMXUtility.getNameStringArray((ObjectName[])names);
        Arrays.sort(modules);
        for (int i = 0; i < modules.length; ++i) {
            Object _name = modules[i];
            int _index = ((String)_name).indexOf("DS_");
            if (_index >= 0) {
                this.directLogWithSpace(((String)_name).substring(_index + "DS_".length()), out);
                continue;
            }
            this.directLogWithSpace((String)_name, out);
        }
    }
}

