/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSDestinationResourceMBean;
import jeus.jms.server.mbean.JMSQueueDestinationResourceMBean;
import jeus.jms.server.mbean.JMSTopicDestinationResourceMBean;
import jeus.jms.server.mbean.stats.JMSDestinationStats;
import jeus.management.JMXUtility;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;

public class JMSStatCommand
extends JMSCommand {
    private static Date TEMP_DATE = new Date();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    private static final int COLUMN_WIDTH = 26;
    private static final int DEFAULT_INTERVAL = 0;
    private Argument destNameArg;
    private ArgumentedOption intervalOption;
    private final Object syncObject = new Object();
    private boolean running;

    public JMSStatCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "stat", "print destination statistics repeatedly", utility, container);
        this.destNameArg = new Argument("dest_name", "destination name");
        this.registerArgument(this.destNameArg);
        this.intervalOption = new ArgumentedOption("i", "interval", "iteration interval in seconds (default is 0, no iteration)");
        this.registerArgument((Argument)this.intervalOption);
    }

    public void run(PrintStream out) throws Exception {
        String destName = this.destNameArg.getValue();
        ObjectName[] destNames = JMXUtility.queryJeusMBean((MBeanServerConnection)this.utility, (String)this.container, (String)"JMSDestinationResource", (String)"Name", (String)destName);
        if (destNames == null) {
            out.println("No destination : " + destName);
        } else {
            JMSDestinationResourceMBean[] mbeans = new JMSDestinationResourceMBean[destNames.length];
            String[] exportNames = new String[destNames.length];
            for (int destIndex = 0; destIndex < destNames.length; ++destIndex) {
                mbeans[destIndex] = (JMSDestinationResourceMBean)JMSStatCommand.newProxyInstance(this.utility, destNames[destIndex], JMSQueueDestinationResourceMBean.class, JMSTopicDestinationResourceMBean.class, false);
                exportNames[destIndex] = mbeans[destIndex].getExportName();
            }
            this.printStats(mbeans, exportNames, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStats(JMSDestinationResourceMBean[] mbeans, String[] exportNames, PrintStream out) {
        int interval = this.readInterval();
        if (interval == 0) {
            this.printCurrentStats(mbeans, exportNames, out);
        } else {
            this.running = true;
            new InputReader().start();
            Object object = this.syncObject;
            synchronized (object) {
                long intervalInMillis = interval * 1000;
                while (this.running) {
                    this.printCurrentStats(mbeans, exportNames, out);
                    try {
                        this.syncObject.wait(intervalInMillis);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    private int readInterval() {
        int interval = 0;
        if (this.intervalOption.isSet()) {
            try {
                int value = Integer.parseInt(this.intervalOption.getValue());
                if (value > 0) {
                    interval = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return interval;
    }

    private void printCurrentStats(JMSDestinationResourceMBean[] mbeans, String[] exportNames, PrintStream out) {
        for (int mbeanIndex = 0; mbeanIndex < mbeans.length; ++mbeanIndex) {
            JMSDestinationStats info = (JMSDestinationStats)mbeans[mbeanIndex].getstats();
            CountStatistic arrival = info.getMessageCount();
            long arrivalCount = arrival.getCount();
            long arrivalStartTime = arrival.getStartTime();
            long arrivalLastTime = arrival.getLastSampleTime();
            CountStatistic completion = info.getDeliveredMessageCount();
            long completionCount = completion.getCount();
            long completionStartTime = completion.getStartTime();
            long completionLastTime = completion.getLastSampleTime();
            out.println("========================================================================");
            out.println("Statistics for " + exportNames[mbeanIndex]);
            out.println("------------------------------------------------------------------------");
            out.println("                              Arrival                  Completion");
            out.println("------------------------------------------------------------------------");
            out.print("Number of messages:   ");
            out.print(JMSStatCommand.printFixSize((String)("" + arrivalCount), (int)26));
            out.print(JMSStatCommand.printFixSize((String)("" + completionCount), (int)26));
            out.println();
            out.print("Start time:           ");
            out.print(JMSStatCommand.printFixSize((String)JMSStatCommand.dateString(arrivalStartTime, arrivalCount), (int)26));
            out.print(JMSStatCommand.printFixSize((String)JMSStatCommand.dateString(completionStartTime, completionCount), (int)26));
            out.println();
            out.print("Last sample time:     ");
            out.print(JMSStatCommand.printFixSize((String)JMSStatCommand.dateString(arrivalLastTime, arrivalCount), (int)26));
            out.print(JMSStatCommand.printFixSize((String)JMSStatCommand.dateString(completionLastTime, completionCount), (int)26));
            out.println();
            out.print("Messages per second:  ");
            out.print(JMSStatCommand.printFixSize((String)JMSStatCommand.speedString(arrivalStartTime, arrivalLastTime, arrivalCount), (int)26));
            out.print(JMSStatCommand.printFixSize((String)JMSStatCommand.speedString(completionStartTime, completionLastTime, completionCount), (int)26));
            out.println();
            out.println("------------------------------------------------------------------------");
            out.println();
        }
    }

    private static String dateString(long time, long count) {
        if (count < 1L) {
            return "N/A";
        }
        TEMP_DATE.setTime(time);
        return DATE_FORMAT.format(TEMP_DATE);
    }

    private static String speedString(long startTime, long lastTime, long count) {
        if (count < 2L) {
            return "N/A";
        }
        long elapasedTime = lastTime - startTime;
        int speedByThousand = (int)((float)(count - 1L) / ((float)elapasedTime / 1000000.0f));
        float speed = (float)speedByThousand / 1000.0f;
        return String.valueOf(speed);
    }

    private class InputReader
    extends Thread {
        private InputReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (JMSStatCommand.this.running) {
                try {
                    System.in.read();
                    System.in.read();
                    JMSStatCommand.this.running = false;
                    Object object = JMSStatCommand.this.syncObject;
                    synchronized (object) {
                        JMSStatCommand.this.syncObject.notifyAll();
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
    }
}

