/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.console.command;

import java.io.IOException;
import java.io.PrintStream;
import javax.management.MBeanServerConnection;
import jeus.jms.console.command.JMSCommand;
import jeus.jms.server.mbean.JMSResourceMBean;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;

public class JMSWorkMonitorCommand
extends JMSCommand {
    private static final int DEFAULT_INTERVAL = 0;
    private ArgumentedOption intervalOption;
    private final Object syncObject = new Object();
    private boolean running;

    public JMSWorkMonitorCommand(AbstractConsoleUtil console, String container, MBeanServerConnection utility) {
        super(console, "workmon", "prints sizes of work queues", utility, container);
        this.intervalOption = new ArgumentedOption("i", "interval", "iteration interval in seconds (default is 0, no iteration)");
        this.registerArgument((Argument)this.intervalOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PrintStream out) throws Exception {
        JMSResourceMBean jmsResource = this.getJMSResourceMBean();
        int interval = this.readInterval();
        if (interval == 0) {
            this.printCurrentSizes(jmsResource, out);
        } else {
            this.running = true;
            new InputReader().start();
            Object object = this.syncObject;
            synchronized (object) {
                long intervalInMillis = interval * 1000;
                while (this.running) {
                    this.printCurrentSizes(jmsResource, out);
                    try {
                        this.syncObject.wait(intervalInMillis);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    private void printCurrentSizes(JMSResourceMBean jmsResource, PrintStream out) {
        Object[][] queueSizes = jmsResource.getQueuedWorkSizes();
        out.println("==============================================");
        out.println("Work queue name                    Queue size");
        out.println("----------------------------------------------");
        for (int queueIndex = 0; queueIndex < queueSizes.length; ++queueIndex) {
            String queueName = (String)queueSizes[queueIndex][0];
            Integer queueSize = (Integer)queueSizes[queueIndex][1];
            out.print(JMSWorkMonitorCommand.printFixSize((String)queueName, (int)35));
            int spaces = 10 - queueSize.toString().length();
            StringBuffer buf = new StringBuffer();
            for (int spaceIndex = 0; spaceIndex < spaces; ++spaceIndex) {
                buf.append(' ');
            }
            buf.append(queueSize);
            out.println(buf.toString());
        }
        out.println("----------------------------------------------");
        out.println();
    }

    private int readInterval() {
        int interval = 0;
        if (this.intervalOption.isSet()) {
            try {
                int value = Integer.parseInt(this.intervalOption.getValue());
                if (value > 0) {
                    interval = value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return interval;
    }

    private class InputReader
    extends Thread {
        private InputReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (JMSWorkMonitorCommand.this.running) {
                try {
                    System.in.read();
                    System.in.read();
                    JMSWorkMonitorCommand.this.running = false;
                    Object object = JMSWorkMonitorCommand.this.syncObject;
                    synchronized (object) {
                        JMSWorkMonitorCommand.this.syncObject.notifyAll();
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
    }
}

