/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import jeus.jms.client.JMSRemoteServerEntryFactory;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.comm.JMSServerEntryContext;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.JMSLocalClientEntry;
import jeus.jms.server.JMSLocalServerEntry;
import jeus.jms.server.comm.JMSBroker;
import jeus.util.concurrent.Sync;

public class JMSLocalServerEntryFactory
extends JMSRemoteServerEntryFactory {
    protected final JMSServerEntry createServerEntryInternal(JMSServerEntryContext entryContext) throws JMSException {
        if (!entryContext.isXaRecovery()) {
            try {
                Sync lock = JMSBroker.getLocalBroker().getLock().readLock();
                if (!lock.attempt(0L)) {
                    throw new JMSException("JMS Server is not prepared yet. Creating new JMSLocalEntry is not allowed.");
                }
                lock.release();
            }
            catch (InterruptedException e) {
                throw JMSExceptionFactory.createJMSException(e.getMessage(), (Exception)e);
            }
        }
        try {
            JMSLocalServerEntry serverEntry = new JMSLocalServerEntry(entryContext);
            JMSLocalClientEntry clientEntry = new JMSLocalClientEntry(serverEntry);
            serverEntry.setMessagePeer(clientEntry);
            serverEntry.start();
            clientEntry.start();
            return serverEntry;
        }
        catch (Throwable t) {
            return super.createServerEntryInternal(entryContext);
        }
    }
}

