/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.server.AbstractProducer;
import jeus.jms.server.JMSSession;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSProducer
extends AbstractProducer {
    private final JMSSession session;

    JMSProducer(JMSSession session, String destName, long connectionID, int producerID) throws JMSException {
        super(destName, connectionID, producerID);
        this.session = session;
        this.producerName = session + ".P" + producerID;
        this.registerMBean();
    }

    public void handleException(MessageContainer packet, JMSException ex) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7251_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7251_LEVEL, JeusMessage_JMS5._7251, packet, (Throwable)ex);
        }
        if (packet.isAdminMessage()) {
            try {
                this.sendFailure(packet, ex);
            }
            catch (JMSException e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7252_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._7252_LEVEL, JeusMessage_JMS5._7252, packet, (Throwable)e);
                }
            }
        } else {
            this.failedMessage((ServerMessage)packet, ex);
        }
    }

    void deliverDestination(ServerMessage message) throws JMSException {
        DestinationIdentity destination = message.getDestination();
        DestinationManager manager = DestinationUtil.getDestinationManager(destination);
        if (message.isTransacted()) {
            this.session.enlistProducer(message, manager);
        } else {
            manager.produce(message);
        }
        this.succeededMessage(message);
    }

    void clientRouting(ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7253_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7253_LEVEL, JeusMessage_JMS5._7253, message);
        }
        this.prepareClientRouting(message);
        if (message.isTransacted()) {
            this.session.enlistTemporaryProducer(message);
            this.acknowledge(message.getMetaHeader(), message.getMessageID());
        } else {
            this.session.sendRoutingRequest(this, message);
        }
    }

    void serverRouting(ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7254_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7254_LEVEL, JeusMessage_JMS5._7254, message);
        }
        this.prepareServerRouting(message);
        this.session.sendRoutingRequest(this, message);
        if (message.isTransacted()) {
            // empty if block
        }
    }

    void checkMessageRouting(ServerMessage message) throws JMSException {
        DestinationIdentity destination = message.getDestination();
        message.setClientRouting(destination.isTemporary());
        String brokerName = destination.getBrokerName();
        message.setServerRouting(brokerName != null && !"".equals(brokerName) && !ClusterManager.LOCAL_BROKER_NAME.equals(brokerName));
    }

    void failedMessage(ServerMessage message, JMSException ex) {
        if (message.isTransacted()) {
            this.session.failedTransaction();
        }
        super.failedMessage(message, ex);
    }

    void registerMBean() throws JMSException {
        super.registerMBean();
        this.session.addJMSProducerStats(this.stats);
    }

    void destroyMBean() {
        super.destroyMBean();
        this.session.removeJMSProducerStats(this.stats);
    }

    void stopProducer(AdminMessage message) throws JMSException {
        if (message.isRequestMessage()) {
            this.sendReplyMessage(message);
        }
    }

    void closeProducer(AdminMessage message) throws JMSException {
        this.shutdown();
        this.session.removeProducer(this.producerID);
        if (message.isRequestMessage()) {
            this.sendReplyMessage(message);
        }
    }

    void increateMessageCounter() {
        super.increateMessageCounter();
        this.session.increaseMessage();
    }

    void sendReplyMessage(AdminMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7255_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7255_LEVEL, JeusMessage_JMS5._7255, message);
        }
        message.setRequestFlag(false);
        this.session.sendMessage(message);
    }

    J2EEManagedObject getParentMBeanObject() {
        return this.session.getMBeanObject();
    }

    private void sendFailure(MessageContainer message, JMSException exception) throws JMSException {
        AdminMessage reply = MessageUtil.createAdminMessage(message.getMetaHeader());
        reply.setException(exception);
        this.sendReplyMessage(reply);
    }
}

