/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.message.ServerMessage;
import jeus.net.SocketStream;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSRelayClientEntry
extends JMSClusterEntry {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private Map remoteToLocalEntryIDMap = new HashMap();
    private Map localToRemoteEntryIDMap = new HashMap();

    public JMSRelayClientEntry(JMSServiceChannel channel, ClusteredPeer peer, SocketStream stream) throws Exception {
        super(channel, peer, stream);
    }

    public void sendData(MessageContainer message) throws JMSException {
        if (message instanceof AdminMessage) {
            AdminMessage adminMessage = (AdminMessage)message;
            if (adminMessage.getOperationID() == 34) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6931_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6931_LEVEL, JeusMessage_JMS5._6931);
                }
                return;
            }
            if (adminMessage instanceof MessageHandleEvent) {
                SingleMessageHandleEvent messageHandleEvent = (SingleMessageHandleEvent)adminMessage;
                MessageID messageID = messageHandleEvent.getMessageID();
                Long localEntryIDLong = new Long(messageHandleEvent.getEntryID());
                Long remoteEntryIDLong = (Long)this.localToRemoteEntryIDMap.get(localEntryIDLong);
                short newBrokerID = this.peer.getBrokerID();
                long newEntryID = remoteEntryIDLong;
                messageHandleEvent.setBrokerID(newBrokerID);
                messageHandleEvent.setEntryID(newEntryID);
                messageHandleEvent.setMessageID(new MessageID(newBrokerID, newEntryID, messageID.getConnectionID(), messageID.getSequenceNumber()));
            }
        }
        super.sendData(message);
    }

    public void recvData(MessageContainer message) {
        block7: {
            if (message instanceof ServerMessage) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6932_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6932_LEVEL, JeusMessage_JMS5._6932, message.dumpString());
                }
                try {
                    Long localEntryID;
                    ServerMessage serverMessage = new ServerMessage(((ServerMessage)message).getClientMessageCopy());
                    MessageID messageID = serverMessage.getMessageID();
                    Long remoteEntryID = new Long(messageID.getEntryID());
                    if (this.remoteToLocalEntryIDMap.containsKey(remoteEntryID)) {
                        localEntryID = (Long)this.remoteToLocalEntryIDMap.get(remoteEntryID);
                    } else {
                        localEntryID = new Long(StorageManager.getNextEntryID());
                        this.remoteToLocalEntryIDMap.put(remoteEntryID, localEntryID);
                        this.localToRemoteEntryIDMap.put(localEntryID, remoteEntryID);
                    }
                    MessageID newMessageID = new MessageID(this.broker.getBrokerID(), localEntryID, messageID.getConnectionID(), messageID.getSequenceNumber());
                    serverMessage.setMessageID(newMessageID);
                    serverMessage.overwriteClientMessageID(newMessageID);
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6933_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS5._6933_LEVEL, JeusMessage_JMS5._6933, serverMessage.dumpString());
                    }
                    message = serverMessage;
                }
                catch (IOException ioe) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6934_LEVEL)) break block7;
                    LogUtils.log(logger, JeusMessage_JMS5._6934_LEVEL, JeusMessage_JMS5._6934, ioe);
                }
            }
        }
        super.recvData(message);
    }

    public boolean isNeedRouting(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6936_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6936_LEVEL, JeusMessage_JMS5._6936);
        }
        return false;
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6935_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6935_LEVEL, JeusMessage_JMS5._6935, this);
        }
        if (this.writer != null) {
            this.writer.connectionClosed();
        }
        this.channel.failedClusterChannel(this);
        this.peer.shutdown();
    }
}

