/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.transaction.xa.XAException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.BrowseQueueMessage;
import jeus.jms.common.message.admin.CreateConsumerMessage;
import jeus.jms.common.message.admin.CreateProducerMessage;
import jeus.jms.common.message.admin.DeliveryCountMessage;
import jeus.jms.common.message.admin.DestinationCommandMessage;
import jeus.jms.common.message.admin.GlobalTransactionMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.RequestConsumerCountMessage;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.common.message.admin.UnsubscribeMessage;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSXid;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.common.util.SerialExecutionQueue;
import jeus.jms.server.JMSConnection;
import jeus.jms.server.JMSConnectionConsumer;
import jeus.jms.server.JMSConsumer;
import jeus.jms.server.JMSMessageConsumer;
import jeus.jms.server.JMSProducer;
import jeus.jms.server.StaleJMSConsumer;
import jeus.jms.server.StaleJMSProducer;
import jeus.jms.server.manager.AbstractSubscriptionManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.manager.TopicSubscriptionManager;
import jeus.jms.server.mbean.JMSSessionResource;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.transaction.SharedTransactionContext;
import jeus.jms.server.transaction.TransactionManager;
import jeus.jms.server.transaction.TransactionalWorks;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public final class JMSSession
implements SubscriptionContext {
    private static ThreadLocal currentTxWorks = new ThreadLocal();
    private final int ackMode;
    private final int sessionID;
    private final String sessionName;
    private final JMSConnection connection;
    private BoundedInteger sequencer;
    private Map consumerList;
    private Map producerList;
    private SynchronizedBoolean closed;
    private SharedTransactionContext sharedTxContext;
    private TransactionalWorks txWorks;
    private JMSSessionResource resource;
    private CountStatisticImpl durableSubscriptionCount;
    private CountStatisticImpl messageCount;
    private CountStatisticImpl commitCount;
    private CountStatisticImpl rollbackCount;
    private CountStatisticImpl transCount;
    private SerialExecution execution;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    JMSSession(JMSConnection connection, int sessionID, int ackMode) throws JMSException {
        this.connection = connection;
        this.sessionID = sessionID;
        this.ackMode = ackMode;
        this.sharedTxContext = connection.getSharedContext();
        this.sessionName = connection + ".S" + sessionID;
        this.registerMBean();
        this.initialize();
    }

    private static void associateTransactionalWorks(TransactionalWorks txContext) {
        currentTxWorks.set(txContext);
    }

    private static void dissociateTransactionalWorks() {
        currentTxWorks.set(null);
    }

    public static TransactionalWorks getCurrentTransactionalWorks() {
        return (TransactionalWorks)currentTxWorks.get();
    }

    public static boolean isLocalTransactionAssociated() {
        return JMSSession.getCurrentTransactionalWorks() != null;
    }

    private void initialize() {
        this.execution = new SerialExecution();
        this.sequencer = BoundedInteger.getIncrementor();
        this.consumerList = Collections.synchronizedMap(new TreeMap());
        this.producerList = Collections.synchronizedMap(new TreeMap());
        if (this.ackMode == 0 && this.sharedTxContext == null) {
            this.txWorks = new TransactionalWorks();
        }
        this.closed = new SynchronizedBoolean(false);
    }

    private void registerMBean() throws JMSException {
        try {
            this.resource = JMSSessionResource.createMBean(this.sessionName, this.connection.getMbeanObject(), this);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
        this.durableSubscriptionCount = (CountStatisticImpl)this.resource.getDurableSubscriptionCount();
        this.messageCount = (CountStatisticImpl)this.resource.getMessageCount();
        this.transCount = (CountStatisticImpl)this.resource.getTransactionCount();
        this.commitCount = (CountStatisticImpl)this.resource.getCommitCount();
        this.rollbackCount = (CountStatisticImpl)this.resource.getRollbackCount();
        this.connection.addJMSSessionStats(this.resource.getstats());
    }

    private void destroyMBean() {
        this.connection.removeJMSSessionStats(this.resource.getstats());
        this.resource.destroyMBean();
    }

    private TransactionalWorks getCurrentTransactionWorks() throws JMSException {
        TransactionalWorks target;
        TransactionalWorks transactionalWorks = this.txWorks != null ? this.txWorks : (target = this.sharedTxContext != null ? this.sharedTxContext.getTransactionContext() : null);
        if (target == null) {
            throw new JMSException("current session is not transacted");
        }
        return target;
    }

    private void checkCurrent() throws XAException {
        if (this.txWorks != null && !this.txWorks.isEmpty()) {
            throw new XAException(-8);
        }
    }

    private AdminMessage startSession(AdminMessage message) {
        return message;
    }

    private AdminMessage stopSession(AdminMessage message) {
        if (message.getBooleanFlag()) {
            this.destroyMBean();
        }
        return message;
    }

    private AdminMessage closeSession(AdminMessage message) {
        this.close();
        return message;
    }

    private AdminMessage startGlobalTransaction(GlobalTransactionMessage start) {
        try {
            this.checkCurrent();
            JMSXid xid = start.getXid();
            int flag = start.getIntegerFlag();
            long timeout = start.getTimeout();
            this.txWorks = this.sharedTxContext == null ? TransactionManager.getInstance().startTransaction(xid, flag, timeout, start.isRemote()) : this.sharedTxContext.getTransactionContext();
        }
        catch (XAException xae) {
            return this.createTxFailMessage(start.getMetaHeader(), xae);
        }
        return this.createTxSuccessMessage(start.getMetaHeader());
    }

    private AdminMessage endGlobalTransaction(GlobalTransactionMessage end) {
        int flag = end.getIntegerFlag();
        JMSXid xid = end.getXid();
        long timeout = end.getTimeout();
        try {
            TransactionManager.getInstance().endTransaction(xid, flag, timeout, end.isRemote());
        }
        catch (XAException xae) {
            xae.printStackTrace();
            return this.createTxFailMessage(end.getMetaHeader(), xae);
        }
        return this.createTxSuccessMessage(end.getMetaHeader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminMessage commitLocalTransaction(AdminMessage commit) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5001_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5001_LEVEL, JeusMessage_JMS5._5001, this);
        }
        TransactionalWorks works = this.getCurrentTransactionWorks();
        try {
            JMSSession.associateTransactionalWorks(works);
            works.commitLocalTransaction(commit.getBooleanFlag());
            this.commitCount.increase();
        }
        finally {
            JMSSession.dissociateTransactionalWorks();
            this.transCount.increase();
        }
        return MessageUtil.createAdminMessage(commit.getMetaHeader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdminMessage rollbackLocalTransaction(AdminMessage rollback) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5002_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5002_LEVEL, JeusMessage_JMS5._5002, this);
        }
        TransactionalWorks works = this.getCurrentTransactionWorks();
        try {
            JMSSession.associateTransactionalWorks(works);
            works.rollbackLocalTransaction();
            this.rollbackCount.increase();
        }
        finally {
            JMSSession.dissociateTransactionalWorks();
            this.transCount.increase();
        }
        return MessageUtil.createAdminMessage(rollback.getMetaHeader());
    }

    private AdminMessage createDurableConsumer(CreateConsumerMessage cdt) throws JMSException {
        String clientID = this.connection.getClientID();
        String durableName = cdt.getDurableName();
        boolean existing = SubscriptionUtil.checkDurableSubscription(clientID, durableName);
        String destName = cdt.getDestinationName();
        TopicManager tm = DestinationUtil.getLocalTopicManager(destName);
        AbstractSubscriptionManager manager = null;
        try {
            String selector = cdt.getSelector();
            boolean noLocal = cdt.getNoLocal();
            boolean started = cdt.getBooleanFlag();
            manager = SubscriptionUtil.addDurableSubscription(this, tm, clientID, durableName, selector, noLocal, false);
            ((SubscriptionManager)manager).setSuspend(!started);
            int consumerID = cdt.isRecovered() ? cdt.getConsumerID() : this.sequencer.getNextValue();
            JMSMessageConsumer consumer = new JMSMessageConsumer((SubscriptionManager)manager, this, this.connection.getEntryID(), this.connection.getConnectionID(), consumerID);
            consumer.activate();
            this.addConsumer(consumerID, consumer);
            cdt.setAllocatedConsumerID(consumerID);
        }
        catch (JMSException ex) {
            if (!existing && manager != null) {
                SubscriptionUtil.removeSubscription(manager.getId());
            }
            throw ex;
        }
        this.durableSubscriptionCount.increase();
        cdt.setTargetID((byte)31);
        return MessageUtil.createAdminMessage(cdt.getMetaHeader());
    }

    private AdminMessage createConsumer(CreateConsumerMessage cq) throws JMSException {
        String destName = cq.getDestinationName();
        DestinationManager destManager = DestinationUtil.getLocalDestinationManager(destName);
        if (!destManager.receiverRegistable()) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5003_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5003_LEVEL, JeusMessage_JMS5._5003, destManager);
            }
            throw new JMSException("destination " + destName + " is exceeding consumer limit : " + destManager);
        }
        SubscriptionManager manager = null;
        try {
            String selector = cq.getSelector();
            boolean noLocal = cq.getNoLocal();
            boolean started = cq.getBooleanFlag();
            manager = SubscriptionUtil.addSubscription(this, destManager, selector, noLocal, false);
            manager.setSuspend(!started);
            int consumerID = cq.isRecovered() ? cq.getConsumerID() : this.sequencer.getNextValue();
            JMSMessageConsumer consumer = new JMSMessageConsumer(manager, this, this.connection.getEntryID(), this.connection.getConnectionID(), consumerID);
            consumer.activate();
            this.addConsumer(consumerID, consumer);
            cq.setAllocatedConsumerID(consumerID);
        }
        catch (JMSException ex) {
            if (manager != null) {
                manager.shutdown();
            }
            throw ex;
        }
        cq.setTargetID((byte)31);
        return MessageUtil.createAdminMessage(cq.getMetaHeader());
    }

    private AdminMessage createProducer(CreateProducerMessage cp) throws JMSException {
        int producerID = cp.getAssignedProducerID();
        if (this.findProducer(producerID) != null) {
            throw new JMSException("producer for id:" + producerID + " is already exists");
        }
        String destination = cp.getDestination();
        JMSProducer producer = new JMSProducer(this, destination, this.connection.getConnectionID(), producerID);
        this.addProducer(producerID, producer);
        cp.setTargetID((byte)47);
        return MessageUtil.createAdminMessage(cp.getMetaHeader());
    }

    private AdminMessage browseQueue(BrowseQueueMessage browse) throws JMSException {
        String queueName = browse.getQueueName();
        String selector = browse.getSelector();
        QueueManager manager = DestinationUtil.getLocalQueueManager(queueName);
        List messages = manager.browse(selector);
        browse.setMessages(messages);
        return browse;
    }

    private AdminMessage acknowledge(MultipleMessageHandleEvent message) throws JMSException {
        int consumerID = message.getConnectionConsumerID();
        JMSConnectionConsumer consumer = this.connection.getConsumer(consumerID);
        boolean transacted = message.isTransacted();
        if (transacted) {
            SubscriptionManager manager = consumer.getSubscriptionManager();
            ListIterator it = message.getMessageIterator();
            while (it.hasNext()) {
                MessageID messageID = (MessageID)it.next();
                this.enlistConsumer(messageID, manager);
            }
        } else {
            ListIterator it = message.getMessageIterator();
            while (it.hasNext()) {
                MessageID messageID = (MessageID)it.next();
                consumer.acknowledge(messageID);
            }
        }
        return MessageUtil.createAdminMessage(message.getMetaHeader());
    }

    private AdminMessage acknowledge(SingleMessageHandleEvent message) throws JMSException {
        int consumerID = message.getConnectionConsumerID();
        JMSConnectionConsumer consumer = this.connection.getConsumer(consumerID);
        boolean transacted = message.isTransacted();
        MessageID messageID = message.getMessageID();
        if (transacted) {
            SubscriptionManager manager = consumer.getSubscriptionManager();
            this.enlistConsumer(messageID, manager);
        } else {
            consumer.acknowledge(messageID);
        }
        return MessageUtil.createAdminMessage(message.getMetaHeader());
    }

    private AdminMessage createTxFailMessage(MetaHeader header, XAException xae) {
        JMSException ex = JMSExceptionFactory.createJMSException("failed transaction", (Exception)xae);
        AdminMessage reply = MessageUtil.createAdminMessage(header, ex);
        reply.setByteFlag((byte)-1);
        return reply;
    }

    private AdminMessage createTxSuccessMessage(MetaHeader header) {
        AdminMessage reply = MessageUtil.createAdminMessage(header);
        reply.setByteFlag((byte)0);
        return reply;
    }

    private AdminMessage requestConsumerCount(RequestConsumerCountMessage requestMsg) {
        String destName = requestMsg.getTopicName();
        TopicManager topicManager = DestinationUtil.findLocalTopicManager(destName);
        if (topicManager == null) {
            requestMsg.setConsumerCount(-1);
            return requestMsg;
        }
        boolean suspended = true;
        List subscriptions = topicManager.getSubscriptionManagers();
        for (TopicSubscriptionManager manager : subscriptions) {
            suspended &= manager.isSuspended();
        }
        requestMsg.setConsumerCount(subscriptions.size());
        requestMsg.setBooleanFlag(suspended);
        return requestMsg;
    }

    private AdminMessage getDeliveryCount(DeliveryCountMessage requestMsg) {
        long deliveryCount = 0L;
        String destName = requestMsg.getDestName();
        TopicManager destManager = (TopicManager)DestinationUtil.findLocalDestinationManager(destName);
        if (destManager == null) {
            requestMsg.setDeliveryCount(-1L);
            return requestMsg;
        }
        boolean suspended = true;
        List subscriptions = destManager.getSubscriptionManagers();
        for (TopicSubscriptionManager manager : subscriptions) {
            deliveryCount += manager.getMessageStatsProvider().getMessageCount().getCount();
            suspended &= manager.isSuspended();
        }
        requestMsg.setDeliveryCount(deliveryCount);
        requestMsg.setBooleanFlag(suspended);
        return requestMsg;
    }

    private AdminMessage suspendConsumers(DestinationCommandMessage message) {
        String destName = message.getDestName();
        TopicManager destManager = (TopicManager)DestinationUtil.findLocalDestinationManager(destName);
        if (destManager != null) {
            List subscriptions = destManager.getSubscriptionManagers();
            for (TopicSubscriptionManager manager : subscriptions) {
                manager.setSuspend(true);
            }
        }
        return message;
    }

    public void sendMessage(MessageContainer message) throws JMSException {
        message.setSessionID(this.sessionID);
        this.forward(message);
    }

    public void sendAsyncRequest(MessageHandler handler, MessageContainer message) throws JMSException {
        message.setSessionID(this.sessionID);
        this.connection.sendAsyncRequest(handler, message);
    }

    public void sendRoutingRequest(MessageHandler handler, MessageContainer message) {
        this.connection.sendRoutingRequest(handler, message);
    }

    private void sendFailedReply(MessageContainer message, JMSException e) throws JMSException {
        message.setSessionID(this.sessionID);
        this.connection.sendFailedReply(message, e);
    }

    private void sendReply(MessageContainer message) throws JMSException {
        message.setRequestFlag(false);
        this.sendMessage(message);
    }

    private void forward(MessageContainer message) throws JMSException {
        this.connection.sendMessage(message);
    }

    private void close() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5004_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5004_LEVEL, JeusMessage_JMS5._5004, this);
        }
        if (!this.closed.commit(false, true)) {
            return;
        }
        this.clearResource();
        this.connection.sessionRemoved(this.sessionID);
    }

    private void clearResource() {
        this.clearLocalTransaction();
        this.consumerList.clear();
        this.producerList.clear();
        this.connection.removeJMSSessionStats(this.resource.getstats());
        this.resource.destroyMBean();
    }

    private void clearLocalTransaction() {
        if (this.isLocalTransacted() && this.txWorks != null) {
            this.txWorks.rollbackLocalTransaction();
        }
    }

    private MessageHandler getConsumer(int consumerID, MessageContainer message) throws JMSException {
        MessageHandler consumer = this.findConsumer(consumerID);
        if (consumer == null) {
            return new StaleJMSConsumer();
        }
        return consumer;
    }

    private MessageHandler getProducer(int producerID, MessageContainer message) throws JMSException {
        MessageHandler producer = this.findProducer(producerID);
        if (producer == null) {
            return new StaleJMSProducer();
        }
        return producer;
    }

    private MessageHandler findConsumer(int consumerID) {
        return (MessageHandler)this.consumerList.get(new Integer(consumerID));
    }

    private MessageHandler findProducer(int producerID) {
        return (MessageHandler)this.producerList.get(new Integer(producerID));
    }

    private void addConsumer(int consumerID, JMSConsumer consumer) {
        this.consumerList.put(new Integer(consumerID), consumer);
    }

    private void addProducer(int producerID, JMSProducer producer) {
        this.producerList.put(new Integer(producerID), producer);
    }

    public void removeConsumer(int consumerID) {
        this.consumerList.remove(new Integer(consumerID));
    }

    public void removeProducer(int producerID) {
        this.producerList.remove(new Integer(producerID));
    }

    public SerialExecutionQueue getExecutionContainer() {
        return this.execution;
    }

    public JMSSessionResource getMBeanObject() {
        return this.resource;
    }

    public void addJMSProducerStats(JMSEndpointStats jmsProducerStats) {
        this.resource.addJMSProducerStats(jmsProducerStats);
    }

    public void addJMSConsumerStats(JMSEndpointStats jmsConsumerStats) {
        this.resource.addJMSConsumerStats(jmsConsumerStats);
    }

    public void removeJMSProducerStats(JMSEndpointStats jmsProducerStats) {
        this.resource.removeJMSProducerStats(jmsProducerStats);
    }

    public void removeJMSConsumerStats(JMSEndpointStats jmsConsumerStats) {
        this.resource.removeJMSConsumerStats(jmsConsumerStats);
    }

    public void enlistProducer(ServerMessage message, DestinationManager manager) throws JMSException {
        this.getCurrentTransactionWorks().addProducer(message, manager);
    }

    public void enlistConsumer(MessageID messageID, SubscriptionManager manager) throws JMSException {
        this.getCurrentTransactionWorks().addConsumer(messageID, manager);
    }

    public void enlistTemporaryProducer(ServerMessage message) throws JMSException {
        this.getCurrentTransactionWorks().addTemporaryProducer(message, this.connection);
    }

    public void failedTransaction() {
        try {
            this.getCurrentTransactionWorks().setRollbackOnly();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public boolean isLocalTransacted() {
        return this.ackMode == 0;
    }

    public boolean isTransacted() {
        return this.isLocalTransacted() || this.txWorks != null;
    }

    public boolean transactionInProgress() {
        return this.isLocalTransacted() || this.isTransacted() && !this.txWorks.isCompleted();
    }

    public void shutdownAll() {
        Collection collection = this.consumerList.values();
        JMSConsumer[] consumers = collection.toArray(new JMSConsumer[collection.size()]);
        for (int i = 0; i < consumers.length; ++i) {
            JMSConsumer consumer = consumers[i];
            consumer.shutdown();
        }
        collection = this.producerList.values();
        JMSProducer[] producers = collection.toArray(new JMSProducer[collection.size()]);
        for (int i = 0; i < producers.length; ++i) {
            JMSProducer producer = producers[i];
            producer.shutdown();
        }
        this.clearResource();
    }

    public void increaseMessage() {
        this.messageCount.increase();
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public String getDigest() {
        return this.sessionName + "";
    }

    public String toString() {
        return this.sessionName;
    }

    public int getAcknowledgeMode() {
        return this.ackMode;
    }

    private class SerialExecution
    extends SerialExecutable
    implements MessageHandler {
        private SerialExecution() {
        }

        public MessageHandler findMessageHandler(MessageContainer message) throws JMSException {
            byte targetID = message.getLocalTargetID();
            switch (targetID) {
                case 47: {
                    int producerID = message.getProducerID();
                    return JMSSession.this.getProducer(producerID, message);
                }
                case 31: {
                    int consumerID = message.getConsumerID();
                    return JMSSession.this.getConsumer(consumerID, message);
                }
            }
            return this;
        }

        public void execute(MessageContainer packet) throws JMSException {
            MessageHandler handler = this.findMessageHandler(packet);
            try {
                handler.handleMessage(packet);
            }
            catch (JMSException e) {
                if (logger.isLoggable(Level.FINE) && LogUtils.isLoggable(logger, JeusMessage_JMS5._5005_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5005_LEVEL, JeusMessage_JMS5._5005, new Object[]{packet, this}, (Throwable)e);
                }
                handler.handleException(packet, e);
            }
        }

        public void exception(MessageContainer packet, JMSException ex) {
            block3: {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5006_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5006_LEVEL, JeusMessage_JMS5._5006, new Object[]{packet, this}, (Throwable)ex);
                }
                try {
                    JMSSession.this.sendFailedReply(packet, ex);
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5007_LEVEL)) break block3;
                    LogUtils.log(logger, JeusMessage_JMS5._5007_LEVEL, JeusMessage_JMS5._5007, new Object[]{packet, this}, (Throwable)e);
                }
            }
        }

        public void failed(MessageContainer packet, Throwable t) {
            block3: {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5008_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5008_LEVEL, JeusMessage_JMS5._5008, new Object[]{packet, this}, t);
                }
                JMSException ex = new JMSException("internal error by " + t != null ? t.toString() : null);
                try {
                    JMSSession.this.sendFailedReply(packet, ex);
                }
                catch (JMSException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5009_LEVEL)) break block3;
                    LogUtils.log(logger, JeusMessage_JMS5._5009_LEVEL, JeusMessage_JMS5._5009, new Object[]{packet, this}, (Throwable)e);
                }
            }
        }

        public void handleMessage(MessageContainer packet) throws JMSException {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5010_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5010_LEVEL, JeusMessage_JMS5._5010, new Object[]{packet, this});
            }
            AdminMessage result = this.handleAdminMessage((AdminMessage)packet);
            if (packet.isRequestMessage()) {
                JMSSession.this.sendReply(result);
            }
        }

        private AdminMessage handleAdminMessage(AdminMessage message) throws JMSException {
            if (message.isPublic()) {
                return this.handlePublicAdminMessage(message);
            }
            switch (message.getOperationID()) {
                case 81: {
                    return JMSSession.this.commitLocalTransaction(message);
                }
                case 82: {
                    return JMSSession.this.rollbackLocalTransaction(message);
                }
                case 97: {
                    return JMSSession.this.endGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 96: {
                    return JMSSession.this.startGlobalTransaction((GlobalTransactionMessage)message);
                }
                case 11: {
                    return JMSSession.this.createConsumer((CreateConsumerMessage)message);
                }
                case 10: {
                    return JMSSession.this.createProducer((CreateProducerMessage)message);
                }
                case 12: {
                    return JMSSession.this.createDurableConsumer((CreateConsumerMessage)message);
                }
                case 4: {
                    return JMSSession.this.startSession(message);
                }
                case 5: {
                    return JMSSession.this.stopSession(message);
                }
                case 6: {
                    return JMSSession.this.closeSession(message);
                }
                case 7: {
                    return JMSSession.this.connection.unsubscribe((UnsubscribeMessage)message);
                }
                case 22: {
                    return JMSSession.this.browseQueue((BrowseQueueMessage)message);
                }
                case 66: {
                    return JMSSession.this.acknowledge((MultipleMessageHandleEvent)message);
                }
                case 50: {
                    return JMSSession.this.acknowledge((SingleMessageHandleEvent)message);
                }
                case 24: {
                    return JMSSession.this.requestConsumerCount((RequestConsumerCountMessage)message);
                }
                case 25: {
                    return JMSSession.this.getDeliveryCount((DeliveryCountMessage)message);
                }
                case 26: {
                    return JMSSession.this.suspendConsumers((DestinationCommandMessage)message);
                }
            }
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
        }

        private AdminMessage handlePublicAdminMessage(AdminMessage message) throws JMSException {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._3100, Byte.toString(message.getOperationID()));
        }

        public void handleException(MessageContainer packet, JMSException ex) {
            block4: {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5011_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5011_LEVEL, JeusMessage_JMS5._5011, new Object[]{packet, this}, (Throwable)ex);
                }
                if (packet.isRequestMessage()) {
                    AdminMessage message = MessageUtil.createAdminMessage(packet.getMetaHeader());
                    message.setException(ex);
                    try {
                        JMSSession.this.sendReply(message);
                    }
                    catch (JMSException e) {
                        if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5012_LEVEL)) break block4;
                        LogUtils.log(logger, JeusMessage_JMS5._5012_LEVEL, JeusMessage_JMS5._5012, message, (Throwable)e);
                    }
                }
            }
        }

        public String toString() {
            return JMSSession.this.sessionName + ".RCV.QUEUE[" + this.size() + "]";
        }
    }
}

