/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.util.ListIterator;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.common.util.MessageHandler;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class StaleJMSConsumer
implements MessageHandler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public void handleMessage(MessageContainer packet) throws JMSException {
        AdminMessage message = (AdminMessage)packet;
        switch (message.getOperationID()) {
            case 66: {
                this.acknowledge((MultipleMessageHandleEvent)message);
                break;
            }
            case 50: {
                this.acknowledge((SingleMessageHandleEvent)message);
                break;
            }
        }
    }

    private void acknowledge(MultipleMessageHandleEvent message) throws JMSException {
        boolean transacted = message.isTransacted();
        ListIterator it = message.getMessageIterator();
        while (it.hasNext()) {
            MessageID messageID = (MessageID)it.next();
            this.handleAcknowlege(transacted, messageID);
        }
    }

    private void acknowledge(SingleMessageHandleEvent message) throws JMSException {
        boolean transacted = message.isTransacted();
        MessageID messageID = message.getMessageID();
        this.handleAcknowlege(transacted, messageID);
    }

    private void handleAcknowlege(boolean transacted, MessageID messageID) throws JMSException {
        if (transacted) {
            return;
        }
    }

    public void handleException(MessageContainer packet, JMSException e) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7161_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7161_LEVEL, JeusMessage_JMS5._7161, packet, (Throwable)e);
        }
    }
}

