/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.comm.JMSContentHandlerCreator;
import jeus.jms.common.comm.SSLParameterFactory;
import jeus.jms.common.util.BoundedInteger;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.JMSClusterConsumer;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.comm.ClusterPeerInfo;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSClusterConnector;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.comm.PeerState;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Journal;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.JmsClientSslType;

public class ClusteredPeer
implements ConnectionListenerFactory,
SubscriptionContext {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private JMSServiceChannelAddress address;
    private JMSServiceChannel channel;
    private Endpoint endpoint;
    private final short brokerID;
    private String brokerName;
    private String hostName;
    private int port;
    private int weight;
    private BoundedInteger consumerSeq;
    private Set subscriptions;
    private JMSClusterConnector connector;
    private SerialExecutor executor;
    private PeerState peerState = PeerState.STATE_STARTED;
    private JmsClientSslType sslDescriptor;

    public ClusteredPeer(JMSServiceChannel channel, short brokerID, String brokerName, String hostName, int port, long connectionInterval, int weight) {
        this(channel, brokerID, brokerName, hostName, port, connectionInterval, weight, null);
    }

    public ClusteredPeer(JMSServiceChannel channel, short brokerID, String brokerName, String hostName, int port, long connectionInterval, int weight, JmsClientSslType sslDescriptor) {
        this(channel, brokerID, brokerName, hostName, port, null, connectionInterval, weight, sslDescriptor);
    }

    public ClusteredPeer(JMSServiceChannel channel, short brokerID, String brokerName, String hostName, int port, String virtualID, long connectionInterval, int weight) {
        this(channel, brokerID, brokerName, hostName, port, virtualID, connectionInterval, weight, null);
    }

    public ClusteredPeer(JMSServiceChannel channel, short brokerID, String brokerName, String hostName, int port, String virtualID, long connectionInterval, int weight, JmsClientSslType sslDescriptor) {
        this.channel = channel;
        this.brokerID = brokerID;
        this.brokerName = brokerName;
        this.hostName = hostName;
        this.port = port;
        this.weight = weight;
        this.address = new JMSServiceChannelAddress(brokerID, brokerName, hostName, port, virtualID);
        this.sslDescriptor = sslDescriptor;
        this.createEndpoint();
        this.init(connectionInterval);
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new JMSClusterEntry(this.channel, this);
    }

    private void createEndpoint() {
        int selectorType = 2;
        String endpointName = "ClusteredPeer-" + this.brokerName + "-Endpoint";
        IOComponentCreator ioComCreator = IOComponentCreator.createBlockingCreator((String)endpointName, (int)selectorType, (boolean)true);
        JMSContentHandlerCreator contentHandlerCreator = new JMSContentHandlerCreator(this.channel.useDirectByteBuffer());
        SSLParameterFactory.SSLParameter param = this.createSSLParameter();
        this.endpoint = new Endpoint(endpointName, ioComCreator, (SocketID)new NoListenID(), (StreamContentHandlerCreator)contentHandlerCreator, (ConnectionListenerFactory)this, param.getSSLContext(), param.getSSLServerSocketFactory(), true);
    }

    private SSLParameterFactory.SSLParameter createSSLParameter() {
        if (this.sslDescriptor == null) {
            return SSLParameterFactory.NULL_PARAMETER;
        }
        Properties props = new Properties();
        props.put("jeus.jms.ssl.keystore.type", this.sslDescriptor.getKeyStoreType());
        props.put("jeus.jms.ssl.keystore.passphrase", this.sslDescriptor.getKeyStorePass());
        if (this.sslDescriptor.getKeyStoreFile() == null) {
            throw new IllegalArgumentException("Key store path must be set.");
        }
        props.put("jeus.jms.ssl.keystore.file", this.sslDescriptor.getKeyStoreFile());
        props.put("jeus.jms.ssl.keymanagement.algorithm", this.sslDescriptor.getKeyManagementAlgorithm());
        props.put("jeus.jms.ssl.truststore.type", this.sslDescriptor.getTrustStoreType());
        props.put("jeus.jms.ssl.truststore.passphrase", this.sslDescriptor.getTrustStorePass());
        if (this.sslDescriptor.getTrustStoreFile() == null) {
            throw new IllegalArgumentException("Trust store path must be set.");
        }
        props.put("jeus.jms.ssl.truststore.file", this.sslDescriptor.getTrustStoreFile());
        props.put("jeus.jms.ssl.trustmanagement.algorithm", this.sslDescriptor.getTrustManagementAlgorithm());
        return SSLParameterFactory.getFactory().createSSLParameter(props, true);
    }

    private void init(long connectionInterval) {
        this.connector = new JMSClusterConnector(this.channel, connectionInterval, this);
        this.executor = new SerialExecutor((Executor)ThreadPoolManager.getThreadPool());
        this.subscriptions = Collections.synchronizedSet(new HashSet());
        this.consumerSeq = BoundedInteger.getIncrementor();
    }

    public boolean transactionInProgress() {
        return false;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public short getBrokerID() {
        return this.brokerID;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getWeight() {
        return this.weight;
    }

    public JMSServiceChannelAddress getAddress() {
        return this.address;
    }

    public Journal getLogger() {
        return logger;
    }

    public void addClusteredSubscription(SubscriptionManager subscription) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5831_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5831_LEVEL, JeusMessage_JMS5._5831, new Object[]{subscription, this});
        }
        this.subscriptions.add(subscription);
    }

    public void start() {
        if (JMSBroker.getLocalBroker().getBrokerID() != this.brokerID) {
            new Thread((Runnable)this.connector, "ClusteredPeer-" + this.connector.toString()).start();
        } else {
            this.connectSuccess();
        }
    }

    public void established(JMSClusterEntry entry) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5832_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5832_LEVEL, JeusMessage_JMS5._5832, this);
        }
        for (SubscriptionManager subscription : this.subscriptions) {
            int consumerID = this.consumerSeq.getNextValue();
            try {
                JMSClusterConsumer consumer = new JMSClusterConsumer(subscription, entry, consumerID);
                consumer.activate();
                entry.registerConsumer(consumerID, consumer);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5833_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS5._5833_LEVEL, JeusMessage_JMS5._5833, subscription, (Throwable)e);
            }
        }
    }

    public void connectionClosed() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5834_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5834_LEVEL, JeusMessage_JMS5._5834, this);
        }
        this.peerState.reset(this);
        for (SubscriptionManager subscription : this.subscriptions) {
            subscription.consumerClosed();
        }
        this.executor.execute(this.connector);
    }

    public void shutdown() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5835_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5835_LEVEL, JeusMessage_JMS5._5835, this);
        }
        this.peerState.reset(this);
        SubscriptionManager[] managers = this.subscriptions.toArray(new SubscriptionManager[this.subscriptions.size()]);
        for (int i = 0; i < managers.length; ++i) {
            SubscriptionManager subscription = managers[i];
            subscription.consumerClosed();
        }
    }

    boolean connected() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5836_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5836_LEVEL, JeusMessage_JMS5._5836, this);
        }
        return this.peerState.connected(this.brokerID, this);
    }

    boolean accepted() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5837_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5837_LEVEL, JeusMessage_JMS5._5837, this);
        }
        return this.peerState.accepted(this.brokerID, this);
    }

    void connectSuccess() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5838_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5838_LEVEL, JeusMessage_JMS5._5838, this);
        }
        this.peerState.connectSuccess(this.brokerID, this);
    }

    void acceptSuccess() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5839_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5839_LEVEL, JeusMessage_JMS5._5839, this);
        }
        this.peerState.acceptSuccess(this.brokerID, this);
    }

    void connectFailed() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5840_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5840_LEVEL, JeusMessage_JMS5._5840, this);
        }
        this.peerState.connectFailed(this);
    }

    void acceptFailed() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5841_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5841_LEVEL, JeusMessage_JMS5._5841, this);
        }
        this.peerState.acceptFailed(this);
    }

    synchronized boolean isEstablished() {
        return this.peerState.isEstablished();
    }

    public int hashCode() {
        return this.brokerName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusteredPeer)) {
            return false;
        }
        ClusteredPeer another = (ClusteredPeer)obj;
        return this.brokerName.equals(another.brokerName);
    }

    synchronized void setPeerState(PeerState newState) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5842_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5842_LEVEL, JeusMessage_JMS5._5842, new Object[]{this.peerState, newState});
        }
        this.peerState = newState;
    }

    public ClusterPeerInfo getClusterInfo() {
        return new ClusterPeerInfo(this, ClusterManager.LOCAL_BROKER_NAME);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(this.brokerID).append(':').append(this.brokerName).append(':').append(this.port).append(']');
        return buf.toString();
    }
}

