/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import jeus.jms.common.util.ISerialExecutable;
import jeus.jms.common.util.Timer;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

class JMSClusterConnector
implements ISerialExecutable {
    private JMSServiceChannel channel;
    private ClusteredPeer peer;
    private long interval;
    private String prevName;
    private Thread executor;
    private SynchronizedBoolean executing = new SynchronizedBoolean(false);
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JMSClusterConnector(JMSServiceChannel channel, long interval, ClusteredPeer peer) {
        this.interval = interval;
        this.channel = channel;
        this.peer = peer;
    }

    public boolean checkExecutor() {
        return this.executing.commit(false, true);
    }

    public boolean isExecuting() {
        return this.executing.get();
    }

    public void setExecuting(boolean execute) {
        this.executing.set(execute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.executor = Thread.currentThread();
        try {
            this.prevName = this.executor.getName();
            this.executor.setName("connector-" + this.peer.getBrokerName());
            this.connect();
        }
        finally {
            this.executor.setName(this.prevName);
            this.executing.set(false);
        }
    }

    public void shutdown() {
        this.executor.interrupt();
    }

    private void connect() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5771_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5771_LEVEL, JeusMessage_JMS5._5771, new Object[]{this.peer.getHostName(), new Integer(this.peer.getPort())});
        }
        Timer timer = new Timer(0L);
        while (!this.executor.isInterrupted() && !this.peer.isEstablished()) {
            try {
                SocketStream stream = this.peer.getEndpoint().getSocketStream((SocketID)this.peer.getAddress());
                if (!this.peer.connected()) {
                    stream.destroy();
                    break;
                }
                this.peer.connectSuccess();
            }
            catch (Exception e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5772_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5772_LEVEL, JeusMessage_JMS5._5772, new Object[]{this, e});
                }
                this.peer.connectFailed();
            }
            timer.elapsWhile(this.interval);
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5773_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5773_LEVEL, JeusMessage_JMS5._5773, this);
        }
    }

    public String toString() {
        return this.peer.toString();
    }
}

