/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.JMSRemoteClientEntry;
import jeus.jms.server.comm.JMSEntryRegistry;

public class JMSEntryRegistryImpl
implements JMSEntryRegistry {
    private Map clients = new HashMap();
    private Map peers = new HashMap();

    public synchronized boolean registerClientEntry(JMSClientEntry entry) {
        return this.clients.put(new Long(entry.getId()), entry) == null;
    }

    public synchronized boolean unregisterClientEntry(JMSClientEntry client) {
        return this.clients.remove(new Long(client.getId())) != null;
    }

    public synchronized boolean registerRemoteClientEntry(JMSRemoteClientEntry client) {
        return this.registerClientEntry(client);
    }

    public synchronized boolean unregisterRemoteClientEntry(JMSRemoteClientEntry client) {
        return this.unregisterClientEntry(client);
    }

    public synchronized boolean registerClusterEntry(short brokerID, JMSClusterEntry client) {
        return this.peers.put(new Short(brokerID), client) == null;
    }

    public synchronized boolean unregisterClusterEntry(short brokerID, JMSClusterEntry client) {
        return this.peers.remove(new Short(brokerID)) != null;
    }

    public JMSClientEntry getClientEntry(long connectionID) throws InvalidDestinationException {
        JMSClientEntry entry = this.findClientEntry(connectionID);
        if (entry == null) {
            throw new InvalidDestinationException("invalid destination id [" + connectionID + "]");
        }
        return entry;
    }

    public JMSClusterEntry getClusterEntry(short brokerID) throws InvalidDestinationException {
        JMSClusterEntry entry = this.findClusterEntry(brokerID);
        if (entry == null) {
            throw new InvalidDestinationException("invalid broker id [" + brokerID + "]");
        }
        return entry;
    }

    public synchronized JMSClientEntry findClientEntry(long connectionID) {
        return (JMSClientEntry)this.clients.get(new Long(connectionID));
    }

    public JMSRemoteClientEntry findRemoteClientEntry(long connectionID) {
        JMSClientEntry entry = this.findClientEntry(connectionID);
        if (entry == null || !entry.isRemote()) {
            return null;
        }
        return (JMSRemoteClientEntry)entry;
    }

    public synchronized JMSClusterEntry findClusterEntry(short brokerID) {
        return (JMSClusterEntry)this.peers.get(new Short(brokerID));
    }

    public synchronized int getClientSize() {
        return this.clients.size();
    }

    public synchronized int getPeerSize() {
        return this.peers.size();
    }

    public synchronized void shutdown() {
        this.shutdownClients();
        this.shutdownPeers();
    }

    void shutdownClients() {
        JMSClientEntry[] clients = this.clients.values().toArray(new JMSClientEntry[0]);
        for (int i = 0; i < clients.length; ++i) {
            clients[i].shutdownAll();
        }
        this.clients.clear();
    }

    void shutdownPeers() {
        JMSClusterEntry[] peers = this.peers.values().toArray(new JMSClusterEntry[0]);
        for (int i = 0; i < peers.length; ++i) {
            peers[i].shutdownAll();
        }
        this.peers.clear();
    }

    public Collection getClientList() {
        return Collections.unmodifiableCollection(this.clients.values());
    }

    public Collection getClusterList() {
        return Collections.unmodifiableCollection(this.peers.values());
    }
}

