/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimerTask;
import javax.jms.InvalidDestinationException;
import javax.jms.ResourceAllocationException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.JMSRemoteEntry;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.LifeCycle;
import jeus.jms.common.comm.JMSContentHandlerCreator;
import jeus.jms.common.comm.MessageWriter;
import jeus.jms.common.comm.NIOMessageWriter;
import jeus.jms.common.comm.SSLParameterFactory;
import jeus.jms.common.logger.JMSLevel;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.JMSRemoteClientEntry;
import jeus.jms.server.JMSServer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSEntryRegistry;
import jeus.jms.server.comm.JMSRemoteEntryAcceptor;
import jeus.jms.server.comm.ServerBlockingMessageWriter;
import jeus.jms.server.manager.Scheduler;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.mbean.JMSServiceChannelMo;
import jeus.jms.server.util.JaxbUtil;
import jeus.management.remote.JeusMPUtility;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.security.base.Environment;
import jeus.security.spi.SecurityInstaller;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Journal;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.util.net.AbstractActiveDispatcher;
import jeus.util.net.JeusSocketDispatcher;
import jeus.util.properties.JeusJMXPropertyValues;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.xml.binding.jeusDD.ClientAuthType;
import jeus.xml.binding.jeusDD.JmsServerSslType;
import jeus.xml.binding.jeusDD.ServiceConfig;

public class JMSServiceChannel
implements JMSEntryRegistry,
LifeCycle,
ConnectionListenerFactory {
    private static InetAddress ANY_INETADDRESS = new InetSocketAddress(1).getAddress();
    private static InetAddress LOOPBACK_INETADDRESS;
    private static final String NAME_PREFIX = "JMSServiceChannel-";
    public static final String JMX_PATH = "/JMX";
    private static final JeusLogger logger;
    private final JMSResource jmsResource;
    private final ServiceConfig descriptor;
    private JMSServiceChannelMo mbean;
    private final SynchronizedInt numOfClients = new SynchronizedInt(0);
    private SynchronizedBoolean shutdown;
    private final JMSServiceChannelAddress address;
    private String name;
    private Endpoint endpoint;
    private final boolean useDirectByteBuffer = false;
    private Journal accessLog;

    JMSServiceChannel(JMSResource engine, ServiceConfig descriptor) {
        this.jmsResource = engine;
        this.descriptor = descriptor;
        this.address = this.createAddress();
    }

    public void init() throws Exception {
        this.name = NAME_PREFIX + this.descriptor.getName();
        this.createEndpoint();
        this.accessLog = this.jmsResource.getAccessLogger();
        this.shutdown = new SynchronizedBoolean(false);
        this.mbean = JMSServiceChannelMo.createMBean(this.name, this.jmsResource, this, this.descriptor);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5801_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5801_LEVEL, JeusMessage_JMS5._5801, this.name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JMSServiceChannelAddress createAddress() {
        String virtualID;
        String host;
        int port;
        if (this.descriptor.isSetServerUrl()) {
            String url = this.descriptor.getServerUrl();
            if (url.startsWith("oneport")) {
                AbstractActiveDispatcher socketDispatcher = (AbstractActiveDispatcher)JeusSocketDispatcher.instance;
                port = socketDispatcher.getPort();
                host = socketDispatcher.getHostAddress();
                if (host.equals(ANY_INETADDRESS.getHostAddress()) || host.equals(LOOPBACK_INETADDRESS.getHostAddress()) || host.equals("localhost")) {
                    host = JeusNetPropertyValues.getLocalInetAddress().getHostAddress();
                }
                virtualID = JMSServiceChannelAddress.createVirtualID(this.getBroker().getBrokerName());
                return new JMSServiceChannelAddress(this.getBroker().getBrokerID(), this.getBroker().getBrokerName(), host, port, virtualID);
            } else {
                if (!url.startsWith("tcp://")) throw new IllegalArgumentException("Unsupported transport");
                String address = this.descriptor.getServerUrl().substring("tcp://".length());
                int index = address.lastIndexOf(":");
                port = Integer.parseInt(address.substring(index + 1));
                host = address.substring(0, index);
                virtualID = null;
            }
            return new JMSServiceChannelAddress(this.getBroker().getBrokerID(), this.getBroker().getBrokerName(), host, port, virtualID);
        } else {
            host = this.descriptor.getServerAddress();
            port = JaxbUtil.getWithDefault(this.descriptor.getPort(), 0);
            virtualID = null;
        }
        return new JMSServiceChannelAddress(this.getBroker().getBrokerID(), this.getBroker().getBrokerName(), host, port, virtualID);
    }

    private void createEndpoint() {
        if (!JMSProperties.isUpperJDK4() && !JaxbUtil.getWithDefault(this.descriptor.isBlockingSocket(), this.descriptor.getDefaultBlockingSocket())) {
            throw new IllegalArgumentException("Non-blocking socket channel is not supported under jdk 1.4.");
        }
        if (JMSProperties.isUpperJDK4() && !JMSProperties.isUpperJDK5() && JaxbUtil.getWithDefault(this.descriptor.isUseSsl(), this.descriptor.getDefaultUseSsl()) && !JaxbUtil.getWithDefault(this.descriptor.isBlockingSocket(), this.descriptor.getDefaultBlockingSocket())) {
            throw new IllegalArgumentException("Unable to create ssl endpoint in jdk1.4 and non-blocking environment.");
        }
        if (JMSProperties.isUpperJDK5() && this.isSupportSSL()) {
            throw new IllegalArgumentException("SSL is not supported in java5 environment yet.");
        }
        IOComponentCreator ioComCreator = JaxbUtil.getWithDefault(this.descriptor.isBlockingSocket(), this.descriptor.getDefaultBlockingSocket()) ? (JMSProperties.isUpperJDK4() ? JeusIOComponentCreator.createChannelBlockingCreator((String)this.name, (int)0) : JeusIOComponentCreator.createSocketBlockingCreator((String)this.name, (int)0)) : JeusIOComponentCreator.createNIOCreator((String)this.name);
        JMSContentHandlerCreator handlerCreator = new JMSContentHandlerCreator(false);
        SSLParameterFactory.SSLParameter param = this.createSSLParameter();
        this.endpoint = new Endpoint(this.name + "-Endpoint", ioComCreator, (SocketID)this.address, (StreamContentHandlerCreator)handlerCreator, (ConnectionListenerFactory)this, param.getSSLContext(), param.getSSLServerSocketFactory(), true, JaxbUtil.getWithDefault(this.descriptor.getBacklogSize(), this.descriptor.getDefaultBacklogSize()));
        this.endpoint.setConnectTimeout(JaxbUtil.getWithDefault(this.descriptor.getConnectionTimeout(), this.descriptor.getDefaultConnectionTimeout()));
    }

    private SSLParameterFactory.SSLParameter createSSLParameter() {
        if (!this.isSupportSSL()) {
            return SSLParameterFactory.NULL_PARAMETER;
        }
        JmsServerSslType sslDescriptor = this.descriptor.getSslConfiguration();
        Properties props = new Properties();
        props.put("jeus.jms.ssl.keystore.type", sslDescriptor.getKeyStoreType());
        props.put("jeus.jms.ssl.keystore.passphrase", sslDescriptor.getKeyStorePass());
        if (sslDescriptor.getKeyStoreFile() == null) {
            throw new IllegalArgumentException("Key store path must be set.");
        }
        props.put("jeus.jms.ssl.keystore.file", sslDescriptor.getKeyStoreFile());
        props.put("jeus.jms.ssl.keymanagement.algorithm", sslDescriptor.getKeyManagementAlgorithm());
        if (sslDescriptor.isSetClientAuth()) {
            ClientAuthType authDescriptor = sslDescriptor.getClientAuth();
            props.put("jeus.jms.ssl.truststore.type", authDescriptor.getTrustStoreType());
            props.put("jeus.jms.ssl.truststore.passphrase", authDescriptor.getTrustStorePass());
            if (authDescriptor.getTrustStoreFile() == null) {
                throw new IllegalArgumentException("Trust store path must be set.");
            }
            props.put("jeus.jms.ssl.truststore.file", authDescriptor.getTrustStoreFile());
            props.put("jeus.jms.ssl.trustmanagement.algorithm", authDescriptor.getTrustManagementAlgorithm());
        }
        return SSLParameterFactory.getFactory().createSSLParameter(props, sslDescriptor.isSetClientAuth());
    }

    public void start() throws IOException {
        if (JMSServer.isStandalone()) {
            int controlListenPort = this.address.getBasePort() + 1;
            if (JeusBootstrapPropertyValues.isUpperJDK4()) {
                JeusSocketDispatcher.setListenPort((int)controlListenPort);
                JeusSocketDispatcher.start((boolean)true);
                try {
                    SecurityInstaller.installSecurity((Environment)Environment.getMasterConfiguration());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                JeusMPUtility.exportJeusMPConnector((int)0, (int)controlListenPort, (String)JMX_PATH, new Hashtable());
            } else {
                JMXServiceURL url = new JMXServiceURL("jmxmp", JeusNetPropertyValues.LOCAL_HOSTADDRESS, controlListenPort);
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, JeusJMXPropertyValues.mBeanServer);
                cs.start();
            }
        }
        this.endpoint.export();
    }

    public void prepareShutdown() {
    }

    public void shutdown() {
        if (!this.shutdown.commit(false, true)) {
            return;
        }
        if (this.endpoint.isExported()) {
            this.endpoint.unexport();
        }
        this.getBroker().shutdown();
        this.numOfClients.set(0);
        try {
            Socket dummy = new Socket("localhost", this.address.getBasePort());
            dummy.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mbean.destroyMBean();
    }

    public void shutdownAll() {
        this.shutdown();
    }

    public boolean registerClientEntry(JMSClientEntry entry) {
        if (this.accessLog.isLoggable(JMSLevel.FATAL)) {
            this.accessLog.directLog("local client " + entry + " is registered to " + this);
        }
        if (this.getBroker().registerClientEntry(entry)) {
            this.numOfClients.increment();
            return true;
        }
        return false;
    }

    public boolean unregisterClientEntry(JMSClientEntry client) {
        if (this.accessLog.isLoggable(JMSLevel.FATAL)) {
            this.accessLog.directLog("local client " + client + " is unregistered from " + this);
        }
        if (this.getBroker().unregisterClientEntry(client)) {
            this.numOfClients.decrement();
            return true;
        }
        return false;
    }

    public boolean registerRemoteClientEntry(JMSRemoteClientEntry client) {
        if (this.accessLog.isLoggable(JMSLevel.FATAL)) {
            this.accessLog.directLog("remote client " + client + " from " + client.getAddress() + " is registered to " + this);
        }
        if (this.getBroker().registerRemoteClientEntry(client)) {
            this.numOfClients.increment();
            return true;
        }
        return false;
    }

    public boolean unregisterRemoteClientEntry(JMSRemoteClientEntry client) {
        if (this.accessLog.isLoggable(JMSLevel.FATAL)) {
            this.accessLog.directLog("remote client " + client + " from " + client.getAddress() + " is unregistered from " + this);
        }
        if (this.getBroker().unregisterRemoteClientEntry(client)) {
            this.numOfClients.decrement();
            return true;
        }
        return false;
    }

    public boolean registerClusterEntry(short brokerID, JMSClusterEntry client) {
        return this.getBroker().registerClusterEntry(brokerID, client);
    }

    public boolean unregisterClusterEntry(short brokerID, JMSClusterEntry client) {
        return this.getBroker().unregisterClusterEntry(brokerID, client);
    }

    public JMSClusterEntry findClusterEntry(short brokerID) {
        return this.getBroker().findClusterEntry(brokerID);
    }

    public JMSClusterEntry getClusterEntry(short brokerID) throws InvalidDestinationException {
        return this.getBroker().getClusterEntry(brokerID);
    }

    public JMSClientEntry findClientEntry(long connectionID) {
        return this.getBroker().findClientEntry(connectionID);
    }

    public JMSClientEntry getClientEntry(long connectionID) throws InvalidDestinationException {
        return this.getBroker().getClientEntry(connectionID);
    }

    public JMSRemoteClientEntry findRemoteClientEntry(long connectionID) {
        return this.getBroker().findRemoteClientEntry(connectionID);
    }

    public void runMessageProcessor(Runnable processor) {
        processor.run();
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        if (socket == null) {
            throw new IllegalArgumentException("local connection is not allowed yet.");
        }
        if (socketID != null) {
            throw new IllegalArgumentException("this factory is not an client connection listener factory.");
        }
        return new JMSRemoteEntryAcceptor(this);
    }

    public void cancelClientChannel(JMSRemoteEntry handler) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5802_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5802_LEVEL, JeusMessage_JMS5._5802, handler);
        }
    }

    public void failedClientChannel(JMSRemoteEntry entry) {
        if (this.mbean.getKeepAliveTime() > 0) {
            EntryShutdownTask entryShutdownTask = new EntryShutdownTask(entry);
            Scheduler.scheduleTask(entryShutdownTask, this.mbean.getKeepAliveTime() * 1000);
        } else {
            entry.shutdownAll();
        }
    }

    public void failedClusterChannel(JMSRemoteEntry entry) {
        entry.shutdownAll();
    }

    private JMSBroker getBroker() {
        return JMSBroker.getLocalBroker();
    }

    public JMSServiceChannelMo getMBean() {
        return this.mbean;
    }

    public int getConnectionTimeout() {
        return JaxbUtil.getWithDefault(this.descriptor.getConnectionTimeout(), this.descriptor.getDefaultConnectionTimeout());
    }

    public boolean isSupportSSL() {
        return JaxbUtil.getWithDefault(this.descriptor.isUseSsl(), this.descriptor.getDefaultUseSsl()) && this.descriptor.isSetSslConfiguration();
    }

    public int getClientLimit() {
        return this.mbean.getClientLimit();
    }

    public boolean isCheckSecurity() {
        return this.mbean.isCheckSecurity();
    }

    public void checkAvailable() throws ResourceAllocationException {
        int clientLimit;
        int clientNum = this.numOfClients.get();
        if (clientNum > (clientLimit = this.mbean.getClientLimit())) {
            throw new ResourceAllocationException("unable to accept more client, current client : " + clientNum + ", limit : " + clientLimit);
        }
    }

    public JMSServiceChannelAddress getServiceChannelAddress() {
        return this.address;
    }

    public ObjectName getObjectName() {
        return this.mbean.getObjectName();
    }

    public String toString() {
        return this.name;
    }

    public MessageWriter createMessageWriter(JMSRemoteEntry entry, SocketStream stream) {
        if (JaxbUtil.getWithDefault(this.descriptor.isBlockingSocket(), this.descriptor.getDefaultBlockingSocket())) {
            return new ServerBlockingMessageWriter(entry, stream);
        }
        return new NIOMessageWriter(entry, stream);
    }

    public boolean useDirectByteBuffer() {
        return false;
    }

    static {
        try {
            LOOPBACK_INETADDRESS = InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            LOOPBACK_INETADDRESS = new InetSocketAddress("127.0.0.1", 1).getAddress();
        }
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }

    private static final class EntryShutdownTask
    extends TimerTask {
        private final JMSRemoteEntry entry;

        public EntryShutdownTask(JMSRemoteEntry entry) {
            this.entry = entry;
        }

        public void run() {
            this.entry.shutdownAll();
        }

        public String toString() {
            return "shutdown task for " + this.entry;
        }
    }
}

