/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.manager.ClusterManager;

abstract class PeerState {
    static final PeerState STATE_STARTED = new PeerStarted();
    static final PeerState STATE_CONNECTED = new PeerConnected();
    static final PeerState STATE_ACCEPTED = new PeerAccepted();
    static final PeerState STATE_CONNECTED_ACCEPTED = new PeerConnectedAccepted();
    static final PeerState STATE_ESTABLISHED = new PeerEstablished();

    PeerState() {
    }

    boolean connected(short brokerID, ClusteredPeer peer) {
        return false;
    }

    boolean accepted(short brokerID, ClusteredPeer peer) {
        return false;
    }

    void connectSuccess(short brokerID, ClusteredPeer peer) {
    }

    void connectFailed(ClusteredPeer peer) {
    }

    void acceptSuccess(short brokerID, ClusteredPeer peer) {
    }

    void acceptFailed(ClusteredPeer peer) {
    }

    void reset(ClusteredPeer peer) {
        peer.setPeerState(STATE_STARTED);
    }

    boolean isEstablished() {
        return this == STATE_ESTABLISHED;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("STATE[");
        buf.append(this.getClass().getName());
        buf.append(']');
        return buf.toString();
    }

    private static class PeerEstablished
    extends PeerState {
        private PeerEstablished() {
        }
    }

    private static class PeerConnectedAccepted
    extends PeerState {
        private PeerConnectedAccepted() {
        }

        void connectSuccess(short brokerID, ClusteredPeer peer) {
            if (ClusterManager.LOCAL_BROKER_ID < brokerID) {
                peer.setPeerState(STATE_ESTABLISHED);
            } else {
                peer.setPeerState(STATE_ACCEPTED);
            }
        }

        void acceptSuccess(short brokerID, ClusteredPeer peer) {
            if (ClusterManager.LOCAL_BROKER_ID > brokerID) {
                peer.setPeerState(STATE_ESTABLISHED);
            } else {
                peer.setPeerState(STATE_CONNECTED);
            }
        }

        void connectFailed(ClusteredPeer peer) {
            peer.setPeerState(STATE_ACCEPTED);
        }

        void acceptFailed(ClusteredPeer peer) {
            peer.setPeerState(STATE_CONNECTED);
        }
    }

    private static class PeerAccepted
    extends PeerState {
        private PeerAccepted() {
        }

        boolean connected(short brokerID, ClusteredPeer peer) {
            if (ClusterManager.LOCAL_BROKER_ID < brokerID) {
                peer.setPeerState(STATE_CONNECTED_ACCEPTED);
                return true;
            }
            return false;
        }

        void acceptSuccess(short brokerID, ClusteredPeer peer) {
            peer.setPeerState(STATE_ESTABLISHED);
        }

        void acceptFailed(ClusteredPeer peer) {
            peer.setPeerState(STATE_STARTED);
        }
    }

    private static class PeerConnected
    extends PeerState {
        private PeerConnected() {
        }

        boolean accepted(short brokerID, ClusteredPeer peer) {
            if (ClusterManager.LOCAL_BROKER_ID > brokerID) {
                peer.setPeerState(STATE_CONNECTED_ACCEPTED);
                return true;
            }
            return false;
        }

        void connectSuccess(short brokerID, ClusteredPeer peer) {
            peer.setPeerState(STATE_ESTABLISHED);
        }

        void connectFailed(ClusteredPeer peer) {
            peer.setPeerState(STATE_STARTED);
        }
    }

    private static class PeerStarted
    extends PeerState {
        private PeerStarted() {
        }

        boolean connected(short brokerID, ClusteredPeer peer) {
            peer.setPeerState(STATE_CONNECTED);
            return true;
        }

        boolean accepted(short brokerID, ClusteredPeer peer) {
            peer.setPeerState(STATE_ACCEPTED);
            return true;
        }
    }
}

