/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.config;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.util.ProtocolUtil;

public class DurableSubscriptionIdentity
implements ISerializable {
    protected transient long id;
    protected String clientID;
    protected String durableName;

    public DurableSubscriptionIdentity() {
    }

    public DurableSubscriptionIdentity(String clientID, String durableName) {
        this.clientID = clientID;
        this.durableName = durableName;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void readExternal(DataInput in) throws IOException {
        this.clientID = ProtocolUtil.readString(in);
        this.durableName = ProtocolUtil.readString(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ProtocolUtil.writeString(this.clientID, out);
        ProtocolUtil.writeString(this.durableName, out);
    }

    public int hashCode() {
        return this.clientID.hashCode() + this.durableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DurableSubscriptionIdentity)) {
            return false;
        }
        DurableSubscriptionIdentity another = (DurableSubscriptionIdentity)obj;
        return this.clientID.equals(another.clientID) && this.durableName.equals(another.durableName);
    }
}

