/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.config;

import javax.jms.ResourceAllocationException;

public class FactoryConstants {
    public static final String NONXA = "nonxa";
    public static final String QUEUE = "queue";
    public static final String TOPIC = "topic";
    public static final String XA = "xa";
    public static final String XA_QUEUE = "xaqueue";
    public static final String XA_TOPIC = "xatopic";
    public static final int CONNECTION_FACTORY = 0;
    public static final int QUEUE_CONNECTION_FACTORY = 1;
    public static final int TOPIC_CONNECTION_FACTORY = 2;
    public static final int XA_CONNECTION_FACTORY = 3;
    public static final int XA_QUEUE_CONNECTION_FACTORY = 4;
    public static final int XA_TOPIC_CONNECTION_FACTORY = 5;

    public static boolean validate(String factoryType) {
        return NONXA.equalsIgnoreCase(factoryType) || QUEUE.equalsIgnoreCase(factoryType) || TOPIC.equalsIgnoreCase(factoryType) || XA.equalsIgnoreCase(factoryType) || XA_QUEUE.equalsIgnoreCase(factoryType) || XA_TOPIC.equalsIgnoreCase(factoryType);
    }

    public static boolean isSupportXA(String factoryType) {
        return XA.equalsIgnoreCase(factoryType) || XA_QUEUE.equalsIgnoreCase(factoryType) || XA_TOPIC.equalsIgnoreCase(factoryType);
    }

    public static int getType(String factoryType) throws ResourceAllocationException {
        if (factoryType.equalsIgnoreCase(NONXA)) {
            return 0;
        }
        if (factoryType.equalsIgnoreCase(QUEUE)) {
            return 1;
        }
        if (factoryType.equalsIgnoreCase(TOPIC)) {
            return 2;
        }
        if (factoryType.equalsIgnoreCase(XA)) {
            return 3;
        }
        if (factoryType.equalsIgnoreCase(XA_QUEUE)) {
            return 4;
        }
        if (factoryType.equalsIgnoreCase(XA_TOPIC)) {
            return 5;
        }
        throw new ResourceAllocationException("invalid type connection factory " + factoryType);
    }

    public static String getTypeString(int factoryType) throws ResourceAllocationException {
        switch (factoryType) {
            case 0: {
                return NONXA;
            }
            case 1: {
                return QUEUE;
            }
            case 2: {
                return TOPIC;
            }
            case 3: {
                return XA;
            }
            case 4: {
                return XA_QUEUE;
            }
            case 5: {
                return XA_TOPIC;
            }
        }
        throw new ResourceAllocationException("invalid type connection factory " + factoryType);
    }
}

