/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jms.JMSException;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.JMSServer;
import jeus.jms.server.config.SAFConfigGenerator;
import jeus.jms.server.manager.ClusterManager;
import jeus.service.descriptor.JMSMainDescriptorFile;
import jeus.util.VirtualDNS;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.BindingHelper;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.JmsServerClusterType;
import jeus.xml.binding.jeusDD.JmsServerType;
import jeus.xml.binding.jeusDD.JmsThreadPoolType;
import jeus.xml.binding.jeusDD.StorageType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class JMSConfig {
    private String engineName;
    private String configPath;
    private JmsServerType jmsServerType;

    public JMSConfig(String engineName, String configPath) throws JMSException {
        this.engineName = engineName;
        this.configPath = configPath;
        try {
            this.jmsServerType = this.getJmsServerType();
            ClusterManager.LOCAL_BROKER_NAME = this.jmsServerType.isSetBrokerName() ? this.jmsServerType.getBrokerName() : VirtualDNS.LOCAL_VIRTUALNAME;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw JMSExceptionFactory.createJMSException("failed initializing jms configuration", ex);
        }
    }

    private JmsServerType getJmsServerType() throws JMSException, IOException, JAXBException {
        if (this.configPath != null) {
            try {
                Document doc = BindingHelper.getDocument((InputStream)new FileInputStream(this.configPath + File.separator + "JMSMain.xml"));
                JmsServerType jmsServerType = (JmsServerType)BindingHelper.getDescriptor(null, (String)"jeus.xml.binding.jeusDD", (Document)doc);
                jmsServerType.fillDefault();
                if (JMSServer.isSAFEngine()) {
                    jmsServerType = SAFConfigGenerator.generate(jmsServerType);
                }
                return jmsServerType;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JMSException(e.getMessage());
            }
        }
        JMSMainDescriptorFile descFile = new JMSMainDescriptorFile(this.engineName);
        return (JmsServerType)descFile.getDeploymentDescriptor((AbstractArchive)JeusManagerPropertyValues.getConfigArchive());
    }

    public void save() throws JAXBException, IOException, SAXException {
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean strip) throws JAXBException, IOException, SAXException {
        JMSMainDescriptorFile descFile = new JMSMainDescriptorFile(this.engineName);
        Object archive = this.configPath != null ? FileArchiveFactory.createArchiveStatic((String)this.configPath) : JeusManagerPropertyValues.getConfigArchive();
        this.jmsServerType.cleanDefault();
        try {
            descFile.marshalDescriptor(this.jmsServerType, (AbstractArchive)archive);
            if (strip) {
                this.jmsServerType.strip(System.out);
            }
        }
        finally {
            this.jmsServerType.fillDefault();
        }
    }

    public StorageType getStorage() {
        return this.jmsServerType.getStorage();
    }

    public JmsThreadPoolType getThreadPool() {
        return this.jmsServerType.getThreadPool();
    }

    public SystemLoggingType getAccessLog() {
        return this.jmsServerType.getAccessLog();
    }

    public List getDestinations() {
        return this.jmsServerType.getDestination();
    }

    public DestinationType findDestination(String name) {
        List destinations = this.getDestinations();
        for (DestinationType descriptor : destinations) {
            if (!descriptor.getName().equals(name)) continue;
            return descriptor;
        }
        return null;
    }

    public List getFactories() {
        return this.jmsServerType.getConnectionFactory();
    }

    public List getDurables() {
        return this.jmsServerType.getDurableSubscriber();
    }

    public JmsServerClusterType getCluster() {
        return this.jmsServerType.getJmsServerCluster();
    }

    public List getQueueClusterConfig() {
        return this.jmsServerType.getQueueCluster();
    }

    public List getTopicClusterConfig() {
        return this.jmsServerType.getTopicCluster();
    }

    public JmsThreadPoolType getThreadPoolType() {
        return this.jmsServerType.getThreadPool();
    }

    public List getServiceConfig() {
        return this.jmsServerType.getServiceConfig();
    }
}

