/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.jms.common.JMSProperties;
import jeus.xml.binding.jeusDD.ClusterDistributeType;
import jeus.xml.binding.jeusDD.DbStorageType;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.DestinationTypeType;
import jeus.xml.binding.jeusDD.EmbeddedType;
import jeus.xml.binding.jeusDD.JmsServerClusterType;
import jeus.xml.binding.jeusDD.JmsServerInfoType;
import jeus.xml.binding.jeusDD.JmsServerType;
import jeus.xml.binding.jeusDD.JmsThreadPoolType;
import jeus.xml.binding.jeusDD.QueueClusterType;
import jeus.xml.binding.jeusDD.RelayTypeType;
import jeus.xml.binding.jeusDD.ServiceConfig;
import jeus.xml.binding.jeusDD.StorageType;
import jeus.xml.binding.jeusDD.TopicClusterType;

class SAFConfigGenerator {
    private static final String LOCAL_SERVICE_NAME = "internal";
    private static final String LOCAL_BROKER_ADDRESS = "127.0.0.1";
    private static final String QUEUE_CLUSTER_NAME = "queue-relay";
    private static final String QUEUE_CLUSTER_DISTRIBUTE_POLICY = "round-robin";
    private static final String TOPIC_CLUSTER_NAME = "topic-relay";
    private static final String TOPIC_RELAY_POLICY = "durable";
    private static final String DEFAULT_REMOTE_BROKER_NAME = "remote";
    private static final short DEFAULT_REMOTE_BROKER_ID = 0;
    private static final short DEFAULT_LOCAL_BROKER_ID = 1;
    private static final int CONNECTION_INTERVAL = 4000;
    private static final int THREAD_POOL_MIN_SIZE = 5;
    private static final int THREAD_POOL_MAX_SIZE = 10;
    private JmsServerType remoteConfig;

    public static JmsServerType generate(JmsServerType remoteConfig) throws JAXBException {
        SAFConfigGenerator generator = new SAFConfigGenerator(remoteConfig);
        return generator.getSAFConfiguration();
    }

    private SAFConfigGenerator(JmsServerType remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    private JmsServerType getSAFConfiguration() throws JAXBException {
        JmsServerType config = this.remoteConfig.cloneJmsServerType();
        config.setBrokerName("JEUS_MQ_SAF_ENGINE");
        config.setThreadPool(this.createThreadPool());
        config.setJmsServerCluster(this.createServerCluster());
        config.setStorage(this.createStorage());
        List serviceConfigs = config.getServiceConfig();
        serviceConfigs.clear();
        serviceConfigs.add(this.createServiceConfig());
        List queueClusters = config.getQueueCluster();
        queueClusters.clear();
        queueClusters.add(this.createQueueCluster());
        List topicClusters = config.getTopicCluster();
        topicClusters.clear();
        topicClusters.add(this.createTopicCluster());
        List destinations = config.getDestination();
        destinations.clear();
        destinations.addAll(this.createDestinations());
        config.setAccessLog(null);
        config.unsetConnectionFactory();
        config.fillDefault();
        return config;
    }

    private ServiceConfig createServiceConfig() {
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setName(LOCAL_SERVICE_NAME);
        serviceConfig.setPort(new Integer(JMSProperties.SAF_ENGINE_PORT));
        return serviceConfig;
    }

    private JmsThreadPoolType createThreadPool() {
        JmsThreadPoolType jmsThreadPool = new JmsThreadPoolType();
        jmsThreadPool.setMin(new Integer(5));
        jmsThreadPool.setMax(new Integer(10));
        return jmsThreadPool;
    }

    private JmsServerClusterType createServerCluster() {
        JmsServerClusterType jmsServerCluster = new JmsServerClusterType();
        JmsServerClusterType remoteCluster = this.remoteConfig.getJmsServerCluster();
        if (remoteCluster == null) {
            ServiceConfig remoteServiceConfig = (ServiceConfig)this.remoteConfig.getServiceConfig().get(0);
            JmsServerInfoType remoteServerInfo = new JmsServerInfoType();
            remoteServerInfo.setBrokerName(DEFAULT_REMOTE_BROKER_NAME);
            remoteServerInfo.setBrokerId((short)0);
            remoteServerInfo.setIpAddress(remoteServiceConfig.getServerAddress());
            remoteServerInfo.setJmsPort(remoteServiceConfig.getPort());
            remoteServerInfo.setConnectionInterval(new Integer(4000));
            jmsServerCluster.getJmsServerInfo().add(remoteServerInfo);
            JmsServerInfoType localServerInfo = new JmsServerInfoType();
            localServerInfo.setBrokerName("JEUS_MQ_SAF_ENGINE");
            localServerInfo.setBrokerId((short)1);
            localServerInfo.setIpAddress(LOCAL_BROKER_ADDRESS);
            localServerInfo.setJmsPort(new Integer(JMSProperties.SAF_ENGINE_PORT));
            localServerInfo.setConnectionInterval(new Integer(4000));
            jmsServerCluster.getJmsServerInfo().add(localServerInfo);
        } else {
            short maxBrokerId = -1;
            for (JmsServerInfoType remoteServerInfo : remoteCluster.getJmsServerInfo()) {
                jmsServerCluster.getJmsServerInfo().add(remoteServerInfo);
                if (maxBrokerId >= remoteServerInfo.getBrokerId()) continue;
                maxBrokerId = remoteServerInfo.getBrokerId();
            }
            JmsServerInfoType localServerInfo = new JmsServerInfoType();
            localServerInfo.setBrokerName("JEUS_MQ_SAF_ENGINE");
            localServerInfo.setBrokerId((short)(maxBrokerId + 1));
            localServerInfo.setIpAddress(LOCAL_BROKER_ADDRESS);
            localServerInfo.setJmsPort(new Integer(JMSProperties.SAF_ENGINE_PORT));
            localServerInfo.setConnectionInterval(new Integer(4000));
            jmsServerCluster.getJmsServerInfo().add(localServerInfo);
        }
        return jmsServerCluster;
    }

    private QueueClusterType createQueueCluster() {
        QueueClusterType queueCluster = new QueueClusterType();
        queueCluster.setQueueClusterName(QUEUE_CLUSTER_NAME);
        queueCluster.setClusterDistribute(ClusterDistributeType.fromValue((String)QUEUE_CLUSTER_DISTRIBUTE_POLICY));
        JmsServerClusterType remoteCluster = this.remoteConfig.getJmsServerCluster();
        if (remoteCluster == null) {
            queueCluster.getTarget().add(DEFAULT_REMOTE_BROKER_NAME);
        } else {
            for (JmsServerInfoType remoteServerInfo : remoteCluster.getJmsServerInfo()) {
                queueCluster.getTarget().add(remoteServerInfo.getBrokerName());
            }
        }
        queueCluster.getTarget().add("JEUS_MQ_SAF_ENGINE");
        return queueCluster;
    }

    private TopicClusterType createTopicCluster() {
        TopicClusterType topicCluster = new TopicClusterType();
        topicCluster.setTopicClusterName(TOPIC_CLUSTER_NAME);
        topicCluster.setRelayType(RelayTypeType.fromValue((String)TOPIC_RELAY_POLICY));
        JmsServerClusterType remoteCluster = this.remoteConfig.getJmsServerCluster();
        if (remoteCluster == null) {
            topicCluster.getTarget().add(DEFAULT_REMOTE_BROKER_NAME);
        } else {
            for (JmsServerInfoType remoteServerInfo : remoteCluster.getJmsServerInfo()) {
                topicCluster.getTarget().add(remoteServerInfo.getBrokerName());
            }
        }
        topicCluster.getTarget().add("JEUS_MQ_SAF_ENGINE");
        return topicCluster;
    }

    private Collection createDestinations() {
        List remoteDestinations = this.remoteConfig.getDestination();
        ArrayList<DestinationType> destinations = new ArrayList<DestinationType>();
        for (DestinationType remoteDest : remoteDestinations) {
            String type = remoteDest.getType().value();
            DestinationType dest = new DestinationType();
            dest.setType(DestinationTypeType.fromValue((String)type));
            dest.setName(remoteDest.getName());
            if (type.equals("queue")) {
                dest.setMultipleReceiver(Boolean.TRUE);
                dest.setQueueClusterName(QUEUE_CLUSTER_NAME);
            } else {
                dest.setTopicClusterName(TOPIC_CLUSTER_NAME);
            }
            destinations.add(dest);
        }
        return destinations;
    }

    private StorageType createStorage() {
        DbStorageType dbStorage = new DbStorageType();
        dbStorage.setEmbedded(new EmbeddedType());
        StorageType storage = new StorageType();
        storage.setDbStorage(dbStorage);
        return storage;
    }
}

