/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.io.DataInput;
import java.io.IOException;
import javax.jms.JMSException;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.common.destination.JeusTopic;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.MultipleQueueManager;
import jeus.jms.server.manager.SingleQueueManager;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.util.JaxbUtil;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.QueueClusterType;
import jeus.xml.binding.jeusDD.TopicClusterType;

public class DestinationFactory {
    public static JeusDestination createDestination(byte type) throws IOException {
        switch (type) {
            case 81: {
                return new JeusQueue();
            }
            case 84: {
                return new JeusTopic();
            }
        }
        throw new IOException("invalid destination type " + type);
    }

    public static JeusDestination createDestination(byte type, DataInput in) throws IOException {
        JeusDestination destination = DestinationFactory.createDestination(type);
        destination.readExternal(in);
        return destination;
    }

    public static JeusDestination createDestination(DestinationType destType) throws JMSException {
        String type = destType.getType().value();
        JeusDestination dest = type.equalsIgnoreCase("Queue") ? DestinationFactory.setupQueue(destType) : DestinationFactory.setupTopic(destType);
        String exportName = destType.getExportName() == null ? destType.getName() : destType.getExportName();
        dest.setExportName(exportName);
        dest.setLimit(JaxbUtil.getWithDefault(destType.getLimit(), destType.getDefaultLimit()));
        dest.setLowMark(JaxbUtil.getWithDefault(destType.getLowMark(), destType.getDefaultLowMark()));
        dest.setHighMark(JaxbUtil.getWithDefault(destType.getHighMark(), destType.getDefaultHighMark()));
        dest.setMaxPendingLimit(JaxbUtil.getWithDefault(destType.getMaxPendingLimit(), destType.getDefaultMaxPendingLimit()));
        dest.setResumeDispatchFactor(JaxbUtil.getWithDefault(destType.getResumeDispatchFactor(), destType.getDefaultResumeDispatchFactor()));
        return dest;
    }

    private static JeusDestination setupQueue(DestinationType destType) throws JMSException {
        String brokerName = destType.getBrokerName();
        String name = destType.getName();
        JeusQueue queue = new JeusQueue(brokerName, name);
        if (brokerName != null) {
            throw new JMSException("The broker name should not be set if the destination is clustered : " + name);
        }
        boolean multiple = JaxbUtil.getWithDefault(destType.isMultipleReceiver(), destType.getDefaultMultipleReceiver());
        if (multiple) {
            queue.setPermitMultipleReceiver(multiple);
            String distribute = JaxbUtil.getWithDefault(destType.getLocalDistribute(), destType.getDefaultLocalDistribute()).value();
            queue.setLocalDistributeType(DestinationFactory.getDistributeTypeValue(distribute));
        }
        if (destType.isSetQueueClusterName()) {
            QueueClusterType cluster = ClusterManager.getQueueClusterPeers(destType.getQueueClusterName());
            queue.setRelays(cluster.getTarget());
            String distribute = JaxbUtil.getWithDefault(cluster.getClusterDistribute(), cluster.getDefaultClusterDistribute()).value();
            byte type = DestinationFactory.getDistributeTypeValue(distribute);
            queue.setDistributeType(type);
            int localPref = JaxbUtil.getWithDefault(cluster.getLocalPreference(), cluster.getDefaultLocalPreference());
            queue.setPreference(localPref);
        }
        queue.setConsumerLimit(JaxbUtil.getWithDefault(destType.getConsumerLimit(), destType.getDefaultConsumerLimit()));
        return queue;
    }

    private static JeusDestination setupTopic(DestinationType destType) throws JMSException {
        String brokerName = destType.getBrokerName();
        String name = destType.getName();
        JeusTopic topic = new JeusTopic(brokerName, name);
        if (destType.isSetTopicClusterName()) {
            if (brokerName != null) {
                throw new JMSException("The broker name should not be set if the destination is clustered : " + name);
            }
            TopicClusterType cluster = ClusterManager.getTopicClusterPeers(destType.getTopicClusterName());
            topic.setRelays(cluster.getTarget());
        }
        topic.setConsumerLimit(JaxbUtil.getWithDefault(destType.getConsumerLimit(), destType.getDefaultConsumerLimit()));
        return topic;
    }

    public static JeusDestination createDestination(byte type, String name, String exportName, boolean multiple, String brokerName) throws JMSException {
        switch (type) {
            case 81: {
                JeusQueue queue = new JeusQueue(brokerName, name);
                queue.setExportName(exportName);
                queue.setPermitMultipleReceiver(multiple);
                return queue;
            }
            case 84: {
                JeusTopic topic = new JeusTopic(brokerName, name);
                topic.setExportName(exportName);
                return topic;
            }
        }
        throw new JMSException("invalid destination type " + type);
    }

    public static DestinationManager createDestinationManager(JeusDestination dest) throws JMSException {
        byte type = dest.getType();
        switch (type) {
            case 81: {
                return DestinationFactory.createQueueManager((JeusQueue)dest);
            }
            case 84: {
                return DestinationFactory.createTopicManager((JeusTopic)dest);
            }
        }
        throw new JMSException("invalid destination type " + type);
    }

    private static DestinationManager createQueueManager(JeusQueue queue) {
        if (queue.isPermitMultipleReceiver()) {
            return new MultipleQueueManager(queue);
        }
        return new SingleQueueManager(queue);
    }

    private static DestinationManager createTopicManager(JeusTopic topic) {
        return new TopicManager(topic);
    }

    private static byte getDistributeTypeValue(String distribute) throws JMSException {
        if (distribute.equalsIgnoreCase("server-weighted")) {
            return 1;
        }
        if (distribute.equalsIgnoreCase("consumer-weighted")) {
            return 2;
        }
        if (distribute.equalsIgnoreCase("round-robin")) {
            return 3;
        }
        if (distribute.equalsIgnoreCase("random")) {
            return 4;
        }
        throw new JMSException("invalid distribution type value " + distribute);
    }
}

