/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.JMSException;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.manager.MessageManager;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.LocalTransactionContext;
import jeus.jms.server.persistence.MessageArchive;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public abstract class DestinationMessageManager
extends MessageManager {
    protected JeusDestination destination;

    protected DestinationMessageManager(JeusDestination destination) {
        super(destination.getId());
        this.destination = destination;
    }

    public boolean requeue(ServerMessage message) {
        return false;
    }

    public boolean prepare(ServerMessage message, long version) throws JMSException {
        LocalTransactionContext context = StorageManager.getCurrentStorage().createLocalTransactionContext();
        try {
            this.prepare(context, message, version);
            context.commit();
        }
        catch (Exception e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6451_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6451_LEVEL, JeusMessage_JMS5._6451, e.getMessage(), (Throwable)e);
            }
            try {
                context.rollback();
            }
            catch (StorageException se) {
                se.printStackTrace();
            }
            if (e instanceof JMSException) {
                throw (JMSException)((Object)e);
            }
            throw JMSExceptionFactory.createJMSException(e);
        }
        finally {
            context.releaseResource();
        }
        return true;
    }

    public boolean prepare(StorageTransactionContext context, ServerMessage message, long version) throws JMSException {
        byte lifeCycle = message.isScheduled() ? (byte)1 : 2;
        this.archive.prepareProduce(context, this.targetId, version, message, lifeCycle);
        return true;
    }

    public boolean commit(ServerMessage message) {
        message.stored(this.archive.createStorageCursor(message));
        message.messageEvent(message.isScheduled() ? (byte)8 : 0);
        return true;
    }

    public boolean rollback(ServerMessage message) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduled(ServerMessage message) {
        try {
            boolean bl = message.isPersisted() && this.archive.enqueue(message.getId());
            return bl;
        }
        finally {
            message.messageEvent((byte)0);
        }
    }

    public boolean distributed(ServerMessage message) {
        return false;
    }

    public boolean completed(ServerMessage message) {
        return this.completed(message, true);
    }

    public boolean completed(ServerMessage message, boolean deleteNow) {
        message.clearResource();
        return deleteNow && message.isPersisted() && this.messageCompleted(message, this.destination);
    }

    public boolean expired(ServerMessage message) {
        message.clearResource();
        return message.isPersisted() && this.messageExpired(message, this.destination);
    }

    protected boolean messageExpired(ServerMessage message, JeusDestination desetination) {
        MessageArchive archive = message.getMessageArchive();
        if (archive == null) {
            archive = this.archive;
        }
        return archive.expired(message.getId(), this.destination.getType() == 81);
    }

    public void deleteAllMessages(JeusDestination destination) throws StorageException {
        this.archive.getStorage().deleteAllMessages(destination);
    }
}

