/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.JMSException;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionMessageManager;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;

public class DurableSubscriptionMessageManager
extends SubscriptionMessageManager {
    public DurableSubscriptionMessageManager(long durableSubscriberId, SubscriptionContext subscriptionContext) {
        super(durableSubscriberId, subscriptionContext);
    }

    public boolean arrived(ServerMessage message) {
        return message.isPersisted() && this.archive.enqueue(message.getId(), this.targetId, message.isStorageRecovered());
    }

    public boolean prepare(StorageTransactionContext context, ServerMessage message) throws JMSException {
        return message.isPersisted() && this.archive.prepareConsume(context, message.getId(), this.targetId);
    }

    public boolean dispatched(ServerMessage message) {
        return !this.subscriptionContext.transactionInProgress() && message.isPersisted() && this.archive.dispatched(message.getId(), this.targetId);
    }

    public boolean completed(ServerMessage message, boolean deleteNow) {
        return !deleteNow || this.subscriptionContext.transactionInProgress() || !message.isPersisted() || this.archive.completed(message.getId(), this.targetId);
    }

    public boolean completed(ServerMessage message) {
        return this.completed(message, true);
    }

    public void deleteAllMessages(long durableSubscriberId) throws StorageException {
        this.archive.getStorage().deleteAllMessages(durableSubscriberId);
    }
}

