/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageInfo;
import jeus.jms.common.message.selector.MessageCheck;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.manager.DummySubscriptionContext;
import jeus.jms.server.manager.DurableSubscriptionMessageManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.TakeoverUtil;
import jeus.jms.server.manager.Takeoverable;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.manager.TopicSubscriptionManager;
import jeus.jms.server.mbean.JMSDurableSubscriberResource;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.util.MessageLifecycle;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public class DurableTopicSubscriptionManager
extends TopicSubscriptionManager
implements Takeoverable {
    private final boolean admin;
    private final String clientID;
    private final String durableName;
    private final String durableID;
    public JMSDurableSubscriberResource resource;

    public DurableTopicSubscriptionManager(SubscriptionContext subscriptionContext, TopicManager manager, DurableSubscriptionConfig config) throws JMSException {
        super(subscriptionContext, config.getId(), manager, config.getSelector(), config.isNolocal(), config.isCluster());
        this.admin = config.isAdmin();
        this.clientID = config.getClientID();
        this.durableName = config.getDurableName();
        this.durableID = this.durableName + "-" + this.clientID;
        this.registerMBean();
        this.initialize();
    }

    public DurableTopicSubscriptionManager(TopicManager manager, DurableSubscriptionConfig config) throws JMSException {
        this(new DummySubscriptionContext(), manager, config);
    }

    void initialize() {
        this.messageManager = new DurableSubscriptionMessageManager(this.id, this.subscriptionContext);
        this.setMaxPendingLimit(this.destination.getDestination().getMaxPendingLimit());
        this.setResumeDispatchFactor(this.destination.getDestination().getResumeDispatchFactor());
        super.initialize();
    }

    public boolean isDurableSubscription() {
        return true;
    }

    void updateConfiguration(DurableSubscriptionConfig config, TopicManager topic) throws JMSException {
        if (this.isActive()) {
            this.checkUpdatable(config);
        }
        this.updateSelector(config.getSelector());
        if (!this.manager.equals(topic)) {
            this.manager.removeSubscriber(this.id);
            topic.addDurableSubscriber(this);
            this.manager = topic;
        }
    }

    public void recoveredConsume(ServerMessage message, byte lifeCycle) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6361_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6361_LEVEL, JeusMessage_JMS5._6361, new Object[]{message, MessageLifecycle.getStringValue(lifeCycle)});
        }
        switch (lifeCycle) {
            case 2: {
                if (this.msgQueue.containsMessage(message.getMessageID())) break;
                ServerMessage clone = this.copyRecoveredMessage(message);
                this.restoredMessage(clone);
                break;
            }
            case 4: {
                ServerMessage restored = this.msgQueue.removeMessage(message.getMessageID());
                if (restored == null) {
                    restored = this.copyRecoveredMessage(message);
                }
                restored.setJMSRedelivered(true);
                this.restoredAcknowledge(restored);
                break;
            }
            case 16: {
                if (this.msgQueue.removeMessage(message.getMessageID()) == null) break;
                message.decreaseReference();
                break;
            }
            default: {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6362_LEVEL)) break;
                LogUtils.log(logger, JeusMessage_JMS5._6362_LEVEL, JeusMessage_JMS5._6362, new Object[]{new Byte(lifeCycle), message});
            }
        }
    }

    public void startDistribution() {
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isDurable() {
        return true;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void consumerClosed() {
        super.consumerClosed();
        this.msgQueue.returnUnackedMessages();
    }

    public void shutdown() {
        super.shutdown();
        this.unregisterMBean();
    }

    public void registerMBean() throws JMSException {
        try {
            ObjectName parent = this.manager.getObjectName();
            this.resource = JMSDurableSubscriberResource.createMBean(this.durableID, parent, this);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("durable consumer " + this.durableID + " is already exists");
        }
    }

    public void unregisterMBean() {
        if (this.resource != null) {
            this.resource.destroyMBean();
        }
        this.resource = null;
    }

    public void unsubscribe() throws JMSException {
        this.checkTransaction();
        this.checkConsumer();
        this.msgQueue.acknowledgeAll();
        this.manager.removeSubscriber(this.id);
        this.shutdown();
    }

    public List getMessageInfo(String selector) throws JMSException {
        MessageCheck check = new MessageCheck(selector);
        ArrayList<MessageInfo> result = new ArrayList<MessageInfo>();
        List queue = this.msgQueue.getQueue();
        for (ServerMessage msg : queue) {
            if (!check.isSelectedMessage(msg)) continue;
            result.add(MessageInfo.createMessageInfo(msg));
        }
        return result;
    }

    public int removeAllMessage() {
        block3: {
            this.msgQueue.setSuspend(true);
            this.msgQueue.returnUnackedMessages();
            for (ServerMessage message : this.msgQueue.removeQueuedMessages()) {
                ((DurableSubscriptionMessageManager)this.messageManager).completed(message, false);
                if (!message.decreaseReference()) continue;
                this.destination.messageEvent(message, (byte)6);
            }
            try {
                ((DurableSubscriptionMessageManager)this.messageManager).deleteAllMessages(this.id);
            }
            catch (StorageException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6363_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._6363_LEVEL, JeusMessage_JMS5._6363, (Throwable)((Object)e));
            }
        }
        int size = this.msgQueue.clearAll();
        this.msgQueue.setSuspend(false);
        return size;
    }

    public void removeMessage(String id) throws JMSException {
        MessageID messageID = MessageID.parseMessageID(id);
        ServerMessage message = this.msgQueue.removeMessage(messageID);
        if (message == null) {
            throw new JMSException("not existing message " + messageID);
        }
    }

    public String getDigest() {
        return this.subscriberName;
    }

    private void checkConsumer() throws JMSException {
        if (this.isActive()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4167);
        }
    }

    String createName() {
        StringBuffer buf = new StringBuffer(96);
        buf.append(this.cluster ? "CDTSM[" : "DTSM[").append(this.id).append(':').append(this.destination).append(':');
        buf.append(this.clientID).append('-').append(this.durableName).append(this.noLocal ? ":NC" + this.connectionID : "").append(']');
        buf.append('[').append(this.consumer == null ? "---" : this.consumer.toString()).append(']');
        return buf.toString();
    }

    public long takeover(MessageHandler handler, JMSClusterEntry activeBrokerEntry) throws Exception {
        long takeovered = this.msgQueue.getQueueSize();
        TakeoverUtil.takeover(this.msgQueue.getQueue(), handler, activeBrokerEntry);
        this.msgQueue.clearAll();
        return takeovered;
    }
}

