/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.JMSServer;
import jeus.jms.server.manager.AbstractSubscriptionManager;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.manager.QueueSubscriptionManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionGroupManager;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.message.MessageDistributor;
import jeus.jms.server.message.ServerMessage;
import jeus.util.LinkedHashMap;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class MultipleQueueManager
extends QueueManager {
    private byte policy;
    private MessageDistributor clusterDistributor;
    private SubscriptionGroupManager localDistributor;
    private Map managers;

    public MultipleQueueManager(JeusQueue queue) {
        super(queue);
        this.initialize(queue);
    }

    private void initialize(JeusQueue queue) {
        this.managers = Collections.synchronizedMap(new LinkedHashMap());
        this.localDistributor = new SubscriptionGroupManager(this, queue.getLocalDistributeType());
        this.managerName = "MQM[" + this.destination.getLocalName() + "]";
        this.initializeDistributor(queue);
        if (!JMSServer.isSAFEngine()) {
            this.addClusterSubscription(this.localDistributor);
        }
    }

    private void initializeDistributor(JeusQueue queue) {
        this.policy = queue.getDistributeType();
        this.clusterDistributor = this.createDistributor();
        if (this.policy == 1) {
            this.localDistributor.setInitialWeight(ClusterManager.getLocalWeight() * queue.getPreference());
        }
    }

    SubscriptionManager addSubscriber(SubscriptionContext subscriptionContext, long id, String selector, boolean noLocal, boolean cluster) throws JMSException {
        this.checkClosed();
        QueueSubscriptionManager manager = new QueueSubscriptionManager(subscriptionContext, id, this, selector, cluster);
        this.addSubscriptionManager(cluster, manager);
        return manager;
    }

    void removeSubscriber(long id) {
        block2: {
            this.localDistributor.removeSubscriber(id);
            try {
                this.callbacks.changeRequest(this.localDistributor.getSize());
            }
            catch (Throwable t) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6301_LEVEL)) break block2;
                LogUtils.log(logger, JeusMessage_JMS5._6301_LEVEL, JeusMessage_JMS5._6301, t);
            }
        }
        SubscriptionUtil.removeSubscription(id);
    }

    public String toString() {
        return super.toString() + ", locals : " + this.localDistributor.getSize() + ", limit : " + this.consumerLimit;
    }

    public boolean receiverRegistable() {
        return this.localDistributor.getSize() < this.consumerLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean distribute(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6302_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6302_LEVEL, JeusMessage_JMS5._6302, message);
        }
        message.startDistribute();
        try {
            if (!JMSServer.isSAFEngine() && (message.isLocalConsume() || this.localDistributor.hasAsyncSubscription())) {
                boolean bl = this.localDistributor.distribute(message);
                return bl;
            }
            boolean bl = this.clusterDistributor.distribute(message);
            return bl;
        }
        finally {
            message.endDistribute();
        }
    }

    public void shutdown() {
        if (!this.closed.commit(false, true)) {
            return;
        }
        ArrayList subscriptions = new ArrayList(this.managers.values());
        for (AbstractSubscriptionManager manager : subscriptions) {
            manager.shutdown();
        }
        this.managers.clear();
        this.clearResources();
    }

    public List getJMSConsumers() {
        ArrayList<AbstractConsumer> v = new ArrayList<AbstractConsumer>();
        ArrayList subscriptions = new ArrayList(this.managers.values());
        for (AbstractSubscriptionManager manager : subscriptions) {
            if (manager.isGroupManager()) {
                v.addAll(this.localDistributor.getJMSConsumers());
                continue;
            }
            SubscriptionManager sm = (SubscriptionManager)manager;
            AbstractConsumer consumer = sm.getMessageConsumer();
            if (consumer == null) continue;
            v.add(consumer);
        }
        return v;
    }

    private synchronized void addSubscriptionManager(boolean cluster, SubscriptionManager manager) {
        if (cluster) {
            this.addClusterSubscription(manager);
        } else {
            this.addSubscription(manager);
        }
    }

    private void addClusterSubscription(AbstractSubscriptionManager manager) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6303_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6303_LEVEL, JeusMessage_JMS5._6303, manager);
        }
        this.managers.put(new Long(manager.getId()), manager);
        manager.setWeight(this.localDistributor.getSize());
        this.clusterDistributor.updated();
    }

    private void addSubscription(SubscriptionManager manager) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6304_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6304_LEVEL, JeusMessage_JMS5._6304, manager);
        }
        this.localDistributor.addSubscriptionManager(manager);
        this.localDistributor.setWeightOnSize();
        this.callbacks.changeRequest(this.localDistributor.getSize());
        this.localDistributor.updated();
    }

    public byte getDistributionPolicy() {
        return this.policy;
    }

    private MessageDistributor createDistributor() {
        switch (this.policy) {
            case 4: {
                return new MessageDistributor.RandomQueueDistributor(this.managers, false);
            }
        }
        return new MessageDistributor.SimpleQueueDistributor(this.managers, false);
    }
}

