/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.InvalidSelectorException;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionMessageManager;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.manager.TopicSubscriptionManager;
import jeus.jms.server.message.ServerMessage;

public class NonDurableTopicSubscriptionManager
extends TopicSubscriptionManager {
    public NonDurableTopicSubscriptionManager(SubscriptionContext subscriptionContext, long id, TopicManager topicManager, String selector, boolean noLocal, boolean cluster) throws InvalidSelectorException {
        super(subscriptionContext, id, topicManager, selector, noLocal, cluster);
        this.initialize();
    }

    void initialize() {
        this.messageManager = new SubscriptionMessageManager(this.id, this.subscriptionContext);
        super.initialize();
    }

    public boolean isDurableSubscription() {
        return false;
    }

    final boolean isSelectedMessage(ServerMessage message) {
        return this.isActive() && super.isSelectedMessage(message);
    }

    public void consumerClosed() {
        super.consumerClosed();
        if (!this.cluster) {
            this.manager.removeSubscriber(this.id);
        }
        this.msgQueue.acknowledgeAll();
        this.messageManager.sync();
    }

    public void shutdown() {
        super.shutdown();
        this.manager.removeSubscriber(this.id);
        this.msgQueue.acknowledgeAll();
        this.messageManager.sync();
    }

    String createName() {
        StringBuffer buf = new StringBuffer(32);
        buf.append(this.cluster ? "CNDTSM[" : "NDTSM[").append(this.id).append(':');
        buf.append(this.destination).append(this.noLocal ? ":NC" + this.connectionID : "").append(']');
        buf.append('[').append(this.consumer == null ? "---" : this.consumer.toString()).append(']');
        return buf.toString();
    }
}

