/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.manager.AbstractSubscriptionManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DummySubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.message.MessageDistributor;
import jeus.jms.server.message.ServerMessage;
import jeus.util.LinkedHashMap;

public class SubscriptionGroupManager
extends AbstractSubscriptionManager
implements MessageDistributor {
    private Map managers = Collections.synchronizedMap(new LinkedHashMap());
    private MessageDistributor policy;
    private int isAsyncDispatchableCount;

    public SubscriptionGroupManager(DestinationManager destination, byte type) {
        super(new DummySubscriptionContext(), -1L, destination, false);
        this.policy = this.createPolicy(type);
    }

    private MessageDistributor createPolicy(byte type) {
        switch (type) {
            case 4: {
                return new MessageDistributor.RandomQueueDistributor(this.managers, true);
            }
        }
        return new MessageDistributor.SimpleQueueDistributor(this.managers, true);
    }

    public boolean enqueueMessage(ServerMessage message) {
        return this.policy.distribute(message);
    }

    public boolean distribute(ServerMessage message) {
        return this.enqueueMessage(message);
    }

    public void updated() {
        this.policy.updated();
    }

    public void shutdown() {
        Collection collection = this.managers.values();
        SubscriptionManager[] subManagers = collection.toArray(new SubscriptionManager[collection.size()]);
        for (int i = 0; i < subManagers.length; ++i) {
            SubscriptionManager manager = subManagers[i];
            manager.shutdown();
        }
        this.managers.clear();
        this.policy.updated();
    }

    synchronized void addSubscriptionManager(SubscriptionManager manager) {
        manager.setNotification(this);
        this.managers.put(new Long(manager.getId()), manager);
        this.policy.updated();
    }

    void setWeightOnSize() {
        this.setWeight(this.managers.size());
    }

    int getSize() {
        return this.managers.size();
    }

    synchronized void removeSubscriber(long id) {
        this.managers.remove(new Long(id));
        this.policy.updated();
    }

    List getJMSConsumers() {
        if (this.managers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AbstractConsumer> v = new ArrayList<AbstractConsumer>();
        SubscriptionManager[] subscriptionManagers = this.managers.values().toArray(new SubscriptionManager[0]);
        for (int i = 0; i < subscriptionManagers.length; ++i) {
            SubscriptionManager manager = subscriptionManagers[i];
            AbstractConsumer consumer = manager.getMessageConsumer();
            if (consumer == null) continue;
            v.add(consumer);
        }
        return v;
    }

    public String toString() {
        return "SUBSCRIPTION-GROUP";
    }

    public boolean hasAsyncSubscription() {
        return this.isAsyncDispatchableCount > 0;
    }

    public synchronized void addAsyncConsumer() {
        ++this.isAsyncDispatchableCount;
    }

    public synchronized void removeAsyncConsumer() {
        --this.isAsyncDispatchableCount;
    }
}

