/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import jeus.jms.common.message.MessageEvent;
import jeus.jms.common.message.MessageEventListener;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.config.DurableSubscriptionConfig;
import jeus.jms.server.manager.AbstractSubscriptionManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.MessageRequest;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionGroupManager;
import jeus.jms.server.manager.SubscriptionMessageManager;
import jeus.jms.server.manager.SubscriptionQueue;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.jms.server.manager.TransactedSubscription;
import jeus.jms.server.mbean.stats.JMSEndpointStatsImpl;
import jeus.jms.server.message.MessageStatsProvider;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.jms.server.transaction.TransactionalWorks;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;

public abstract class SubscriptionManager
extends AbstractSubscriptionManager
implements TransactedSubscription,
MessageEventListener {
    private SynchronizedBoolean shutdown;
    protected AbstractConsumer consumer;
    protected long entryID;
    protected int connectionID;
    private SerialExecutor executor;
    protected SubscriptionQueue msgQueue;
    protected MessageStatsProvider stats;
    private Set participating;
    private int maxPendingLimit;
    private float resumeDispatchFactor;
    protected SubscriptionMessageManager messageManager;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private SubscriptionGroupManager listener;

    public SubscriptionManager(SubscriptionContext subscriptionContext, long id, DestinationManager destination, String selector, boolean cluster) throws InvalidSelectorException {
        super(subscriptionContext, id, destination, cluster);
        this.setSelector(selector);
    }

    void initialize() {
        this.shutdown = new SynchronizedBoolean(false, (Object)this);
        this.executor = new SerialExecutor((Executor)ThreadPoolManager.getThreadPool());
        this.msgQueue = new SubscriptionQueue(this);
        this.stats = new MessageStatsProvider();
        this.stats.createTemporaryStats(new JMSEndpointStatsImpl());
        this.subscriberName = this.createName();
    }

    public synchronized void activate(AbstractConsumer update) throws JMSException {
        if (this.isActive()) {
            throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4064);
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6081_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6081_LEVEL, JeusMessage_JMS5._6081, new Object[]{this, update});
        }
        this.consumer = update;
        this.consumer.setListener(this.listener);
        this.entryID = update.getEntryID();
        this.connectionID = update.getConnectionID();
        this.subscriberName = this.createName();
        this.stats.update(update.getStats());
        this.executor.execute(this.msgQueue, false);
        this.destination.activated(this);
    }

    public void syncRequest(AdminMessage message) {
        DirectMessageRequest request = new DirectMessageRequest(message);
        this.msgQueue.handleSyncRequest(request);
    }

    public void asyncRequest() {
        this.msgQueue.cancelSyncRequests();
        this.executor.execute(this.msgQueue, !this.msgQueue.isEmpty());
    }

    public void cancelSyncRequests() {
        this.msgQueue.cancelSyncRequests();
    }

    public void executeDispatch() {
        this.executor.execute(this.msgQueue, !this.msgQueue.isEmpty());
    }

    public boolean enqueueMessage(ServerMessage message) {
        if (this.shutdown.get() || this.cluster && message.isLocalConsume()) {
            return false;
        }
        boolean selected = this.isSelectedMessage(message);
        if (selected) {
            this.messageEvent(message, (byte)0);
        }
        return selected;
    }

    public void acknowledge(MessageID messageID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6082_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6082_LEVEL, JeusMessage_JMS5._6082, new Object[]{messageID, this});
        }
        this.msgQueue.acknowledge(messageID);
    }

    public void nacknowledge(MessageID messageID) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6083_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6083_LEVEL, JeusMessage_JMS5._6083, new Object[]{messageID, this});
        }
        this.msgQueue.removeAcknowledge(messageID);
    }

    public void consume(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6084_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6084_LEVEL, JeusMessage_JMS5._6084, new Object[]{message, this});
        }
        this.acknowledge(message.getMessageID());
    }

    public boolean prepareConsume(StorageTransactionContext context, ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6085_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6085_LEVEL, JeusMessage_JMS5._6085, message);
        }
        return this.messageManager.prepare(context, message);
    }

    public void commitConsume(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6086_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6086_LEVEL, JeusMessage_JMS5._6086, message);
        }
        this.acknowledge(message.getMessageID());
    }

    public void rollbackConsume(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6087_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6087_LEVEL, JeusMessage_JMS5._6087, message);
        }
        this.messageManager.rollback(message);
        this.recover(message.getMessageID());
    }

    public void recoveredConsume(ServerMessage message, byte lifeCycle) {
    }

    public void recover(MessageID messageID) {
        ServerMessage message = this.msgQueue.findAcknowledge(messageID);
        if (message != null) {
            if (message.getDeliveryCount() < message.getRedeliveryLimit()) {
                this.msgQueue.recover(messageID, true);
                this.msgQueue.startExecution();
            } else {
                this.poisonedMessage(messageID);
            }
        }
    }

    public void returnBack(MessageID messageID) {
        this.msgQueue.returnBack(messageID);
    }

    public ServerMessage findAcknowledge(MessageID messageID) {
        return this.msgQueue.findAcknowledge(messageID);
    }

    public ServerMessage getAcknowledge(MessageID messageID) throws JMSException {
        ServerMessage message = this.msgQueue.findAcknowledge(messageID);
        if (message == null) {
            throw new JMSException("failed to find message " + messageID + " in ack queue ");
        }
        return message;
    }

    public void poisonedMessage(MessageID messageID) {
        ServerMessage message;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6088_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6088_LEVEL, JeusMessage_JMS5._6088, messageID);
        }
        if ((message = this.msgQueue.findAcknowledge(messageID)) != null) {
            DestinationManager manager = DestinationUtil.getDeadLetterQueue();
            manager.enqueue(message);
            this.msgQueue.acknowledge(messageID);
        }
    }

    public void messageEvent(ServerMessage message, byte event) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6089_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6089_LEVEL, JeusMessage_JMS5._6089, new Object[]{MessageEvent.getEventType(event), message, this});
        }
        switch (event) {
            case 0: {
                this.messageArrived(message);
                break;
            }
            case 4: {
                this.messageDispatched(message);
                break;
            }
            case 5: {
                this.messageDelivered(message);
                break;
            }
            case 20: {
                this.messageExpired(message);
                break;
            }
            case 40: {
                this.messageFailed(message);
                break;
            }
        }
    }

    void restoredMessage(ServerMessage message) {
        this.msgQueue.enqueueMessage(message);
    }

    void restoredAcknowledge(ServerMessage message) {
        this.msgQueue.enqueueAcknowledge(message);
    }

    boolean dispatch(ServerMessage message) throws JMSException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("subscription " + this + " is already closed");
        }
        AbstractConsumer dispatcher = this.getMessageConsumer();
        if (dispatcher == null) {
            return false;
        }
        return dispatcher.dispatch(message);
    }

    void dispatchFailed(ServerMessage message) {
    }

    void messageArrived(ServerMessage message) {
        message.setSubscriptionEventListener(this);
        message.setObserved(false);
        this.stats.messageArrived(message);
        this.messageManager.arrived(message);
        this.msgQueue.dispatchMessage(message, false);
    }

    private void messageDispatched(ServerMessage message) {
        this.messageManager.dispatched(message);
        this.stats.messageDispatched(message);
    }

    void messageDelivered(ServerMessage message) {
        this.stats.messageDelivered(message);
    }

    private void messageExpired(ServerMessage message) {
        this.stats.messageExpired(message);
        this.msgQueue.removeMessage(message.getMessageID());
        this.msgQueue.removeAcknowledge(message.getMessageID());
    }

    void messageFailed(ServerMessage message) {
        this.stats.messageFailed(message);
    }

    synchronized AbstractConsumer getMessageConsumer() {
        return this.isActive() ? this.consumer : null;
    }

    private synchronized void resetMessageConsumer() {
        if (this.consumer != null) {
            this.consumer.subscriptionClosed();
        }
        this.consumer = null;
        this.subscriberName = this.createName();
    }

    public int getMaxPendingLimit() {
        return this.maxPendingLimit;
    }

    public void setMaxPendingLimit(int maxPendingLimit) {
        this.maxPendingLimit = maxPendingLimit;
    }

    public float getResumeDispatchFactor() {
        return this.resumeDispatchFactor;
    }

    public void setResumeDispatchFactor(float resumeDispatchFactor) {
        this.resumeDispatchFactor = resumeDispatchFactor;
    }

    synchronized boolean isActive() {
        return !this.shutdown.get() && this.consumer != null && !this.consumer.isClosed();
    }

    synchronized boolean isSyncDispatchable() {
        return !this.shutdown.get() && this.consumer != null && this.msgQueue.syncRequested();
    }

    synchronized boolean isAsyncDispatchable() {
        return !this.shutdown.get() && this.consumer != null && this.consumer.isAsyncDispatchable();
    }

    synchronized boolean isDispatchable() {
        return !this.shutdown.get() && this.consumer != null && (this.msgQueue.syncRequested() || this.consumer.isAsyncDispatchable());
    }

    synchronized boolean isXAParticipant() {
        return this.participating != null && !this.participating.isEmpty();
    }

    void checkTransaction() throws TransactionInProgressException {
        if (this.isXAParticipant()) {
            throw new TransactionInProgressException("subscription is particiating in transaction");
        }
    }

    void checkUpdatable(DurableSubscriptionConfig config) throws InvalidDestinationException {
        if (!this.destName.equals(config.getDestinationName())) {
            throw new InvalidDestinationException(this.destName);
        }
    }

    public synchronized void enlisted(TransactionalWorks branch) {
        if (this.participating == null) {
            this.participating = new HashSet();
        }
        this.participating.add(branch);
    }

    public synchronized void delisted(TransactionalWorks branch) {
        if (this.participating == null) {
            return;
        }
        this.participating.remove(branch);
    }

    public void consumerClosed() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6090_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6090_LEVEL, JeusMessage_JMS5._6090, this);
        }
        this.resetMessageConsumer();
        this.msgQueue.consumerClosed();
    }

    public void shutdown() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6091_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6091_LEVEL, JeusMessage_JMS5._6091, this);
        }
        this.shutdown.commit(false, true);
        this.resetMessageConsumer();
        this.msgQueue.consumerClosed();
    }

    public void dispatchCompleted() {
        if (this.shutdown.get()) {
            this.shutdown();
        }
    }

    public int getMessageNumber() {
        return this.msgQueue.getQueueSize();
    }

    public void refesh() {
        this.stats.setPendingMessageCount(this.msgQueue.getQueueSize());
    }

    public void setSuspend(boolean suspend) {
        this.msgQueue.setSuspend(suspend);
    }

    public boolean isSuspended() {
        return this.msgQueue.isSuspended();
    }

    public boolean isDurable() {
        return false;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public MessageStatsProvider getMessageStatsProvider() {
        return this.stats;
    }

    abstract String createName();

    public String toString() {
        return this.subscriberName;
    }

    public void setNotification(SubscriptionGroupManager subscriptionGroupManager) {
        this.listener = subscriptionGroupManager;
    }

    class DirectMessageRequest
    implements MessageRequest {
        private SynchronizedBoolean invalid = new SynchronizedBoolean(false);
        private boolean noblock;
        private long timeoutDue;
        private int observerID;

        public DirectMessageRequest(AdminMessage request) {
            this.observerID = request.getObserverID();
            this.noblock = request.getBooleanFlag();
            long waitTime = request.getLongFlag();
            this.timeoutDue = waitTime == 0L ? 0L : System.currentTimeMillis() + waitTime;
        }

        public void execute(ServerMessage message) {
            this.preExecution(message);
            SubscriptionManager.this.msgQueue.startWork(message);
        }

        public boolean isValid() {
            return !this.invalid.get();
        }

        public boolean isBlockingRequest() {
            return !this.noblock;
        }

        public boolean isSelectedMessage(UserMessage message) {
            return true;
        }

        public boolean isApplicable(ServerMessage message, long current) {
            return !this.invalid.get() && this.timeoutDue == 0L || this.timeoutDue > current;
        }

        public void preExecution(ServerMessage message) {
            message.setObserverID(this.observerID);
        }

        public boolean commit(ServerMessage message, long current) {
            return this.invalid.commit(false, true);
        }

        public String toString() {
            return this.observerID + (this.noblock ? "" : "-->" + (this.timeoutDue == 0L ? "infinite" : new Date(this.timeoutDue).toString()));
        }
    }
}

