/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.util.concurrent.Sync;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class TakeoverExecutor
implements MessageHandler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.takeover");
    private String activeBrokerName;
    private JMSClusterEntry activeBrokerEntry;
    private Exception exception;

    public TakeoverExecutor(String activeBrokerName) {
        this.activeBrokerName = activeBrokerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long takeover() throws Exception {
        JMSBroker standbyBroker = JMSBroker.getLocalBroker();
        ClusteredPeer activeBroker = ClusterManager.getClusterPeer(this.activeBrokerName);
        this.checkActiveBroker(activeBroker);
        this.checkEstablished(activeBroker);
        this.activeBrokerEntry = standbyBroker.getClusterEntry(activeBroker.getBrokerID());
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6391_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6391_LEVEL, JeusMessage_JMS5._6391, new Object[]{standbyBroker.getBrokerName(), new Short(standbyBroker.getBrokerID()), activeBroker.getBrokerName(), new Short(activeBroker.getBrokerID())});
        }
        long takeovered = 0L;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6392_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6392_LEVEL, JeusMessage_JMS5._6392);
        }
        Sync lock = standbyBroker.getLock().writeLock();
        lock.acquire();
        try {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6393_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6393_LEVEL, JeusMessage_JMS5._6393);
            }
            standbyBroker.prepareTakeover(activeBroker.getBrokerID());
            DestinationManager[] destinationManagers = DestinationUtil.getAllDestinationManagers();
            for (int i = 0; i < destinationManagers.length; ++i) {
                DestinationManager destinationManager = destinationManagers[i];
                if (destinationManager.getDestination().getExportName().endsWith("_JMS_DLQ")) continue;
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6394_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6394_LEVEL, JeusMessage_JMS5._6394, destinationManager.getDestinationName());
                }
                long count = destinationManager.takeover(this, this.activeBrokerEntry);
                if (this.exception != null) {
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6395_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS5._6395_LEVEL, JeusMessage_JMS5._6395, destinationManager.getDestinationName());
                    }
                    throw this.exception;
                }
                takeovered += count;
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6396_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS5._6396_LEVEL, JeusMessage_JMS5._6396, new Object[]{destinationManager.getDestinationName(), new Long(count)});
            }
        }
        finally {
            lock.release();
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6397_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6397_LEVEL, JeusMessage_JMS5._6397, new Long(takeovered));
        }
        return takeovered;
    }

    public void handleException(MessageContainer packet, JMSException e) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6398_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6398_LEVEL, JeusMessage_JMS5._6398, e);
        }
        this.exception = e;
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        this.activeBrokerEntry.sendReplyMessage(packet);
    }

    private void checkEstablished(ClusteredPeer activeBroker) throws JMSException {
        if (!activeBroker.getClusterInfo().isEstablished()) {
            throw new JMSException("Active broker " + this.activeBrokerName + " is not a established broker.");
        }
    }

    private void checkActiveBroker(ClusteredPeer activeBroker) throws JMSException {
        if (activeBroker.getBrokerID() >= JMSBroker.getLocalBroker().getBrokerID()) {
            throw new JMSException("Broker " + this.activeBrokerName + " is not a active broker.");
        }
    }
}

