/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import jeus.jms.server.util.JaxbUtil;
import jeus.util.DaemonThreadFactory;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executors;
import jeus.util.concurrent50.concurrent.ThreadFactory;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.JmsThreadPoolType;

public class ThreadPoolManager {
    private static final String JMS_EXECUTOR = "JMSServer";
    private static final String JMS_CACHED_EXECUTOR = "JMSServer-Cached";
    private static ThreadPoolExecutor threadPool;
    private static ThreadPoolExecutor cachedThreadPool;
    protected static final JeusLogger logger;

    public static void init(JmsThreadPoolType threadPoolType) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6161_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6161_LEVEL, JeusMessage_JMS5._6161, ThreadPoolManager.class.getName());
        }
        threadPool = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)JMS_EXECUTOR, (int)JaxbUtil.getWithDefault(threadPoolType.getMax(), threadPoolType.getDefaultMax()), (int)JaxbUtil.getWithDefault(threadPoolType.getMin(), threadPoolType.getDefaultMin()), (long)JaxbUtil.getWithDefault(threadPoolType.getKeepAliveTime(), threadPoolType.getDefaultKeepAliveTime()), (boolean)false);
        cachedThreadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory(JMS_CACHED_EXECUTOR));
    }

    public static ThreadPoolExecutor getThreadPool() {
        return threadPool;
    }

    public static ThreadPoolExecutor getCachedThreadPool() {
        return cachedThreadPool;
    }

    public static void execute(Runnable runnable) throws InterruptedException {
        threadPool.execute(runnable);
    }

    public static void executeCached(Runnable runnable) throws InterruptedException {
        cachedThreadPool.execute(runnable);
    }

    public static void shutdown() {
        if (threadPool != null) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6162_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6162_LEVEL, JeusMessage_JMS5._6162, threadPool);
            }
            threadPool.shutdownNow();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6163_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6163_LEVEL, JeusMessage_JMS5._6163, cachedThreadPool);
            }
            cachedThreadPool.shutdownNow();
        }
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }
}

