/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import javax.management.InstanceAlreadyExistsException;
import jeus.jms.server.JMSConnectionConsumer;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.mbean.JMSConnectionConsumerResourceMBean;
import jeus.jms.server.mbean.JMSConnectionResource;
import jeus.jms.server.mbean.JMSEndPointResource;
import jeus.jms.server.mbean.stats.JMSConsumerStatsImpl;

public class JMSConnectionConsumerResource
extends JMSEndPointResource
implements JMSConnectionConsumerResourceMBean {
    private final JMSConnectionResource parent;
    private final JMSConnectionConsumer target;
    private SubscriptionManager subscription;

    public static JMSConnectionConsumerResource createMBean(String mBeanName, JMSConnectionResource parent, JMSConnectionConsumer target) throws InstanceAlreadyExistsException {
        JMSConnectionConsumerResource resource = new JMSConnectionConsumerResource(parent, target);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), JMSConnectionConsumerResourceMBean.parentKeyMap, "JMSConnectionConsumerResource");
        return resource;
    }

    public JMSConnectionConsumerResource(JMSConnectionResource parent, JMSConnectionConsumer target) {
        this.parent = parent;
        this.target = target;
        this.subscription = target.getSubscriptionManager();
        this.stats = new JMSConsumerStatsImpl(this.subscription.getDestinationName());
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".C" + this.target.getConsumerID();
    }

    public String getDestinationName() {
        return this.subscription.getDestinationName();
    }

    public String getDigest() {
        return this.target.getDigest();
    }

    public String getName() {
        return this.target == null ? "INVALID" : this.target.toString();
    }

    public boolean isDurable() {
        return false;
    }

    public boolean isConnectionConsumer() {
        return true;
    }

    protected void refresh() {
        this.target.refresh();
    }

    public String toString() {
        return this.target.toString();
    }
}

