/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.server.JMSConnection;
import jeus.jms.server.mbean.JMSClientResource;
import jeus.jms.server.mbean.JMSConnectionResourceMBean;
import jeus.jms.server.mbean.stats.JMSConnectionStatsImpl;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEResource;
import jeus.management.j2ee.statistics.CountStatisticImpl;

public class JMSConnectionResource
extends J2EEResource
implements JMSConnectionResourceMBean {
    private final JMSClientResource parent;
    private final JMSConnection target;
    private final JMSConnectionStatsImpl stats;
    private Vector sessionNames = new Vector();
    private Vector connectionConsumerNames = new Vector();
    protected static String[] parentKeyMap = new String[]{"JeusManager", "J2EEServer", "JMSResource", "JMSServiceChannel", "JMSClientResource"};

    public static JMSConnectionResource createMBean(String mBeanName, JMSClientResource parent, JMSConnection target) throws InstanceAlreadyExistsException {
        JMSConnectionResource resource = new JMSConnectionResource(parent, target);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), parentKeyMap, "JMSConnectionResource");
        return resource;
    }

    public JMSConnectionResource(JMSClientResource parent, JMSConnection target) {
        this.parent = parent;
        this.target = target;
        this.stats = new JMSConnectionStatsImpl(this);
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".C" + this.target.getConnectionID();
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSSessionResource")) {
            this.sessionNames.add(pChild);
        } else {
            this.connectionConsumerNames.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSSessionResource")) {
            this.sessionNames.remove(pChild);
        } else {
            this.connectionConsumerNames.add(pChild);
        }
        super.removeChild(pChild);
    }

    public void addJMSSessionStats(Stats stats) {
        this.stats.addJMSSessionStats(stats);
    }

    public void removeJMSSessionStats(Stats stats) {
        this.stats.removeJMSSessionStats(stats);
    }

    public void addJMSConsumerStats(Stats stats) {
        this.stats.addJMSConnectionConsumerStats(stats);
    }

    public void removeJMSConsumerStats(Stats stats) {
        this.stats.removeJMSConnectionConsumerStats(stats);
    }

    public Stats getstats() {
        return this.stats;
    }

    public String getName() {
        return this.target.toString();
    }

    public List getJMSSessionResourceNames() {
        return new ArrayList(this.sessionNames);
    }

    public List getJMSConnectionConsumerResourceNames() {
        return new ArrayList(this.connectionConsumerNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getSessionCount() {
        CountStatisticImpl stat = this.stats.getSessionCount();
        if (stat != null) {
            return stat;
        }
        JMSConnectionStatsImpl jMSConnectionStatsImpl = this.stats;
        synchronized (jMSConnectionStatsImpl) {
            stat = this.stats.getSessionCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createSessionCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getConnectionConsumerCount() {
        CountStatisticImpl stat = this.stats.getConnectionConsumerCount();
        if (stat != null) {
            return stat;
        }
        JMSConnectionStatsImpl jMSConnectionStatsImpl = this.stats;
        synchronized (jMSConnectionStatsImpl) {
            stat = this.stats.getConnectionConsumerCount();
            if (stat != null) {
                return stat;
            }
            return this.stats.createConnectionConsumerCount();
        }
    }

    public String getDigest() {
        return this.target.getDigest();
    }

    public boolean isTransactional() {
        return this.target.isTransacted();
    }

    public String toString() {
        return this.target.toString();
    }
}

