/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import javax.management.InstanceAlreadyExistsException;
import jeus.jms.server.JMSConsumer;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.mbean.JMSConsumerResourceMBean;
import jeus.jms.server.mbean.JMSEndPointResource;
import jeus.jms.server.mbean.stats.JMSConsumerStatsImpl;
import jeus.management.j2ee.J2EEManagedObject;

public class JMSConsumerResource
extends JMSEndPointResource
implements JMSConsumerResourceMBean {
    private final JMSConsumer target;
    private final J2EEManagedObject parent;
    private final SubscriptionManager subscription;

    public static JMSConsumerResource createMBean(String mBeanName, J2EEManagedObject parent, JMSConsumer target) throws InstanceAlreadyExistsException {
        JMSConsumerResource resource = new JMSConsumerResource(parent, target);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), JMSConsumerResourceMBean.parentKeyMap, "JMSConsumerResource");
        return resource;
    }

    public JMSConsumerResource(J2EEManagedObject parent, JMSConsumer target) {
        this.parent = parent;
        this.target = target;
        this.subscription = target.getSubscriptionManager();
        this.stats = new JMSConsumerStatsImpl(this.subscription.getDestinationName());
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".C" + this.target.getConsumerID();
    }

    public String getDestinationName() {
        return this.subscription.getDestinationName();
    }

    public String getDigest() {
        return this.target.getDigest();
    }

    public String getName() {
        return this.target.toString();
    }

    public boolean isDurable() {
        return this.subscription.isDurable();
    }

    public boolean isConnectionConsumer() {
        return false;
    }

    protected void refresh() {
        this.target.refresh();
    }

    public String toString() {
        return this.target.toString();
    }
}

