/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.mbean.JMSDestinationResourceMBean;
import jeus.jms.server.mbean.JMSDestinationStatsImpl;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.mbean.stats.JMSEndpointStats;
import jeus.management.j2ee.J2EEResource;

public abstract class JMSDestinationResource
extends J2EEResource
implements JMSDestinationResourceMBean {
    protected JMSResource parent;
    protected DestinationManager target;
    protected JeusDestination destination;
    protected JMSDestinationStatsImpl stats;

    public JMSDestinationResource(DestinationManager target, JMSResource parent) {
        this.target = target;
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.destination = this.target.getDestination();
        this.stats = new JMSDestinationStatsImpl();
    }

    public String getName() {
        return this.destination.getLocalName();
    }

    public String getExportName() {
        return this.destination.getExportName();
    }

    public int getType() {
        return this.destination.getType();
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Stats getstats() {
        this.refreshTarget();
        return this.stats;
    }

    public JMSEndpointStats getinitialStats() {
        this.stats.createMessageCount();
        this.stats.createExpiredMessageCount();
        this.stats.createPendingMessageCount();
        this.stats.createDeliveredMessageCount();
        this.stats.createMessageWaitTime();
        return this.stats;
    }

    protected void refreshTarget() {
        if (this.target != null) {
            this.target.refresh();
        }
    }

    public List getJMSConsumerResourceNames() {
        List consumers = this.target.getJMSConsumers();
        ArrayList<String> list = new ArrayList<String>(consumers.size());
        for (int i = 0; i < consumers.size(); ++i) {
            AbstractConsumer consumer = (AbstractConsumer)consumers.get(i);
            list.add(consumer.toString());
        }
        return list;
    }

    public void resetMessageStats() {
        this.stats = (JMSDestinationStatsImpl)this.target.resetMessageStats();
    }
}

