/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.io.Serializable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.jms.server.JMSServer;
import jeus.jms.server.mbean.JMSEngineMoMBean;
import jeus.management.j2ee.manager.EngineMo;
import jeus.security.spi.LoginService;
import jeus.server.enginecontainer.EngineContainerException;

public class JMSEngineMo
extends EngineMo
implements JMSEngineMoMBean {
    private final JMSServer server;
    private final String engineName;

    public static JMSEngineMo createMBean(String engineName, ObjectName parent, JMSServer target) throws InstanceAlreadyExistsException {
        JMSEngineMo resource = new JMSEngineMo(engineName, target, parent);
        if (!JMSServer.isStandalone()) {
            resource.createMBean(engineName, "JeusService", parent, JMSEngineMoMBean.parentKeyMap, "JMSEngine");
        }
        return resource;
    }

    public JMSEngineMo(String engineName, JMSServer server, ObjectName parent) {
        super(parent);
        this.engineName = engineName;
        this.server = server;
    }

    public void sendNotification(String event, String message, Serializable userData) {
        if (!JMSServer.isStandalone()) {
            super.sendNotification(event, message, userData);
        }
    }

    public void start() throws Exception {
        if (JMSServer.isStandalone()) {
            try {
                this.setStart(null, null);
                this.preStart();
                this.postStart();
                this.setRunning(null, null);
            }
            catch (Exception e) {
                this.setFailed(null, null);
                throw e;
            }
        } else {
            super.start();
        }
    }

    public void stop() throws Exception {
        if (JMSServer.isStandalone()) {
            try {
                this.setStopping(null, null);
                this.preStop();
                this.postStop();
                this.setStopped(null, null);
            }
            catch (Exception e) {
                this.setFailed(null, null);
                throw e;
            }
        } else {
            super.stop();
        }
    }

    public void down() throws EngineContainerException {
        LoginService.checkCodeSubject();
        this.server.shutdown();
    }

    public void destroyMBean() {
        if (!JMSServer.isStandalone()) {
            super.destroyMBean();
        }
    }

    public String getEngineName() {
        return this.engineName;
    }

    protected String initPermissionName() {
        return "jeus.management.jmsEngine." + this.engineName;
    }
}

