/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.security.Permission;
import java.util.List;
import javax.jms.JMSException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.mbean.JMSDestinationResource;
import jeus.jms.server.mbean.JMSQueueDestinationResourceMBean;
import jeus.jms.server.mbean.JMSResource;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.PermissionMaker;

public class JMSQueueDestinationResource
extends JMSDestinationResource
implements JMSQueueDestinationResourceMBean {
    private ResourcePermission removeMessagePermission;
    private ResourcePermission removeAllMessagesPermission;
    private QueueManager target;

    public static JMSQueueDestinationResource createMBean(String mBeanName, JMSResource parent, QueueManager target) throws InstanceAlreadyExistsException {
        JMSQueueDestinationResource resource = new JMSQueueDestinationResource(target, parent);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), JMSQueueDestinationResourceMBean.parentKeyMap, "JMSDestinationResource");
        return resource;
    }

    public JMSQueueDestinationResource(QueueManager target, JMSResource parent) {
        super(target, parent);
        this.removeAllMessagesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"removeAllMessages");
        this.target = target;
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".queue." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.removeMessagePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"removeMessage");
        this.removeAllMessagesPermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"removeAllMessages");
    }

    public boolean isQueue() {
        return true;
    }

    public boolean isTopic() {
        return false;
    }

    public List getMessageInfo(String selector) throws JMSException {
        return this.target.getMessageInfo(selector);
    }

    public int getRemainingMessages() {
        return this.target.getRemainingMessages();
    }

    public long getMessageCount() {
        return this.target.getMessageCount();
    }

    public long getExpiredMessageCount() {
        return this.target.getExpiredMessageCount();
    }

    public long getMessageWaitMaxTime() {
        return this.target.getMessageWaitMaxTime();
    }

    public long getMessageWaitMinTime() {
        return this.target.getMessageWaitMinTime();
    }

    public long getMessageWaitTotalTime() {
        return this.target.getMessageWaitTotalTime();
    }

    public List getPendingMessageInfo(String selector) throws JMSException {
        return this.target.getPendingMessageInfo(selector);
    }

    public void requeuePendingMessage(String messageID, boolean isNewDeliver) throws JMSException {
        this.target.requeuePendingMessage(messageID, isNewDeliver);
    }

    public int getRemainingPendingMessages() {
        return this.target.getRemainingPendingMessages();
    }

    public int removeAllMessages() throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.removeAllMessagesPermission);
        }
        catch (Exception e) {
            throw new JMSException("not enough permission to remove message");
        }
        return this.target.removeAllMessage();
    }

    public void removeMessage(String messageID) throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.removeMessagePermission);
        }
        catch (Exception e) {
            throw new JMSException("not enough permission to remove message");
        }
        this.target.removeMessage(messageID);
    }
}

