/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean.stats;

import java.util.Vector;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.server.mbean.JMSConnectionResourceMBean;
import jeus.jms.server.mbean.stats.JMSConnectionConsumerStats;
import jeus.jms.server.mbean.stats.JMSConnectionStats;
import jeus.jms.server.mbean.stats.JMSConsumerStats;
import jeus.jms.server.mbean.stats.JMSSessionStats;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.StatsImpl;

public class JMSConnectionStatsImpl
extends StatsImpl
implements JMSConnectionStats,
JMSConnectionConsumerStats {
    private transient JMSConnectionResourceMBean mbean;
    private Vector sessionStats = new Vector();
    private Vector connectionConsumerStats = new Vector();
    private static final JMSSessionStats[] emptyJMSSessionStats = new JMSSessionStats[0];
    private static final JMSConsumerStats[] emptyJMSConnectionConsumerStats = new JMSConsumerStats[0];
    public String sessionCount = "SessionCount";
    public String connectionConsumerCount = "ConnectionConsumerCount";

    public JMSConnectionStatsImpl(JMSConnectionResourceMBean _mbean) {
        this.mbean = _mbean;
    }

    public boolean isTransactional() {
        if (this.mbean == null) {
            return false;
        }
        return this.mbean.isTransactional();
    }

    public CountStatisticImpl getSessionCount() {
        return (CountStatisticImpl)this.getStatistic(this.sessionCount);
    }

    public CountStatisticImpl getConnectionConsumerCount() {
        return (CountStatisticImpl)this.getStatistic(this.connectionConsumerCount);
    }

    public CountStatisticImpl createSessionCount() {
        CountStatisticImpl connectionCount = new CountStatisticImpl(this.sessionCount, "session", "the number of live sessions for a connection");
        this.setStatistic((Statistic)connectionCount);
        return connectionCount;
    }

    public CountStatisticImpl createConnectionConsumerCount() {
        CountStatisticImpl connectionCount = new CountStatisticImpl(this.connectionConsumerCount, "connectionConsumer", "the number of live connection consumers for a connection");
        this.setStatistic((Statistic)connectionCount);
        return connectionCount;
    }

    public javax.management.j2ee.statistics.JMSSessionStats[] getSessions() {
        return this.sessionStats.toArray(emptyJMSSessionStats);
    }

    public javax.management.j2ee.statistics.JMSConsumerStats[] getConnectionConsumers() {
        return this.connectionConsumerStats.toArray(emptyJMSConnectionConsumerStats);
    }

    public void addJMSSessionStats(Stats stats) {
        this.sessionStats.add(stats);
    }

    public void addJMSConnectionConsumerStats(Stats stats) {
        this.connectionConsumerStats.add(stats);
    }

    public void removeJMSSessionStats(Stats stats) {
        this.sessionStats.remove(stats);
    }

    public void removeJMSConnectionConsumerStats(Stats stats) {
        this.connectionConsumerStats.remove(stats);
    }
}

