/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.message;

import jeus.jms.server.mbean.stats.JMSEndpointStats;
import jeus.jms.server.mbean.stats.JMSEndpointStatsImpl;
import jeus.jms.server.message.MessageStatistics;
import jeus.jms.server.message.ServerMessage;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;

public class MessageStatsProvider
implements MessageStatistics {
    private CountStatisticImpl messageCount;
    private CountStatisticImpl expiredMessageCount;
    private CountStatisticImpl pendingMessageCount;
    private TimeStatisticImpl messageWaitTime;
    private CountStatisticImpl deliveredMessageCount;

    public void init(JMSEndpointStats mbean) {
        this.messageCount = (CountStatisticImpl)mbean.getMessageCount();
        this.expiredMessageCount = (CountStatisticImpl)mbean.getExpiredMessageCount();
        this.pendingMessageCount = (CountStatisticImpl)mbean.getPendingMessageCount();
        this.deliveredMessageCount = (CountStatisticImpl)mbean.getDeliveredMessageCount();
        this.messageWaitTime = (TimeStatisticImpl)mbean.getMessageWaitTime();
    }

    public JMSEndpointStatsImpl createTemporaryStats(JMSEndpointStatsImpl stats) {
        stats.createMessageCount();
        stats.createExpiredMessageCount();
        stats.createPendingMessageCount();
        stats.createDeliveredMessageCount();
        stats.createMessageWaitTime();
        this.init(stats);
        return stats;
    }

    public void update(JMSEndpointStats mbean) {
        ((CountStatisticImpl)mbean.getMessageCount()).update(this.messageCount);
        ((CountStatisticImpl)mbean.getExpiredMessageCount()).update(this.expiredMessageCount);
        ((CountStatisticImpl)mbean.getPendingMessageCount()).update(this.pendingMessageCount);
        ((CountStatisticImpl)mbean.getDeliveredMessageCount()).update(this.deliveredMessageCount);
        ((TimeStatisticImpl)mbean.getMessageWaitTime()).update(this.messageWaitTime);
        this.init(mbean);
    }

    public void messageArrived(ServerMessage message) {
        this.messageCount.increase();
    }

    public void messageExpired(ServerMessage message) {
        this.expiredMessageCount.increase();
    }

    public void messageDispatched(ServerMessage message) {
        long queuedTime = message.getQueuedTime();
        if (queuedTime == 0L) {
            return;
        }
        this.messageWaitTime.addData(System.currentTimeMillis() - queuedTime);
    }

    public void messageDelivered(ServerMessage message) {
        this.deliveredMessageCount.increase();
    }

    public void messageFailed(ServerMessage message) {
    }

    public void setPendingMessageCount(int count) {
        this.pendingMessageCount.setValue((long)count);
    }

    public CountStatisticImpl getMessageCount() {
        return this.messageCount;
    }

    public CountStatisticImpl getExpiredMessageCount() {
        return this.expiredMessageCount;
    }

    public CountStatisticImpl getPendingMessageCount() {
        return this.pendingMessageCount;
    }

    public CountStatisticImpl getDeliveredMessageCount() {
        return this.deliveredMessageCount;
    }

    public TimeStatisticImpl getMessageWaitTime() {
        return this.messageWaitTime;
    }
}

