/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.message;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import jeus.jms.client.message.ClientMessageFactory;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageFactory;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.util.BufferInputStream;
import jeus.jms.common.util.MemoryBufferInputStream;
import jeus.jms.common.util.Utility;
import jeus.jms.server.persistence.StorageCursor;
import jeus.nio.ByteBufferWrapper;

class StoredPacketHandler {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private int allocation;
    private ByteBufferWrapper content;
    private ClientMessage message;
    private Reference reference;
    private StorageCursor cursor;

    public StoredPacketHandler(ByteBufferWrapper content) {
        this.content = content;
        this.allocation = content.limit();
    }

    public StoredPacketHandler(ClientMessage message) {
        this.message = message;
    }

    public StoredPacketHandler(StorageCursor cursor) {
        this.cursor = cursor;
    }

    public int occupied() {
        return this.allocation;
    }

    public synchronized void setStorageCursor(StorageCursor cursor) {
        this.cursor = cursor;
    }

    private synchronized StorageCursor getCursor() throws IOException {
        if (this.cursor == null) {
            throw new IOException("packet is missing");
        }
        return this.cursor;
    }

    private synchronized ByteBufferWrapper softenByteBuffer(ByteBufferWrapper packet) {
        this.reference = new SoftReference<ByteBufferWrapper>(packet);
        return packet.duplicate();
    }

    public synchronized void softenContent(boolean close) {
        this.reference = close ? null : new SoftReference<ByteBufferWrapper>(this.content);
        this.content = null;
    }

    public synchronized void clear() {
        if (this.reference != null && this.getFromReference() != null) {
            ByteBufferWrapper.free(this.getFromReference());
        }
        if (this.content != null) {
            ByteBufferWrapper.free(this.content);
        }
        this.reference = null;
        this.content = null;
        this.message = null;
        this.allocation = 0;
    }

    private ByteBufferWrapper getContentFromReferenceWithoutSerialization() {
        ByteBufferWrapper buffer;
        ByteBufferWrapper byteBufferWrapper = this.content != null ? this.content : (buffer = this.reference != null ? (ByteBufferWrapper)this.reference.get() : null);
        if (buffer != null) {
            return buffer.duplicate();
        }
        return null;
    }

    public ByteBufferWrapper getContentFromReference() throws IOException {
        return this.getContentFromReference(false);
    }

    public ByteBufferWrapper getContentFromReference(boolean direct) throws IOException {
        ByteBufferWrapper buffer = this.getContentFromReferenceWithoutSerialization();
        if (buffer == null && this.message != null) {
            buffer = MessageFactory.serializeForWrite(this.message, 512, direct);
            return this.softenByteBuffer(buffer);
        }
        return buffer;
    }

    public ByteBufferWrapper getContentFromStorage(boolean direct) throws IOException {
        ByteBufferWrapper buffer = this.getContentFromReference(direct);
        if (buffer != null) {
            return buffer;
        }
        buffer = this.getCursor().getContent(direct);
        if (buffer == null) {
            throw new IOException("packet is missing");
        }
        return this.softenByteBuffer(buffer);
    }

    public BufferInputStream getContentFromReferenceAsInputStream() throws IOException {
        ByteBufferWrapper buffer = this.getContentFromReference();
        return new MemoryBufferInputStream(buffer);
    }

    public ClientMessage getContentFromStorageAsMessage(MetaHeader header) throws IOException {
        if (this.message == null) {
            ByteBufferWrapper buffer = this.getContentFromStorage(false);
            MemoryBufferInputStream stream = new MemoryBufferInputStream(buffer);
            this.message = ClientMessageFactory.createUserMessage(header, stream);
            return this.message;
        }
        ClientMessage clone = (ClientMessage)this.message.clone();
        clone.getMetaHeader().copyFrom(header);
        return clone;
    }

    private ByteBufferWrapper getFromReference() {
        return this.reference != null ? (ByteBufferWrapper)this.reference.get() : null;
    }

    public void overwriteClientMessageID(MessageID messageID) {
        if (this.message != null) {
            this.message.setMessageID(messageID);
            this.message.setBrokerID(messageID.getBrokerID());
            this.message.setEntryID(messageID.getEntryID());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("StoredPacketHandle[content=");
        buf.append(this.content == null ? "null" : Utility.getDump(this.content, true));
        buf.append(",message=");
        buf.append(this.message == null ? "null" : this.message.dumpString());
        buf.append(",reference=");
        buf.append(this.reference);
        buf.append("]");
        return buf.toString();
    }
}

