/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence;

import javax.jms.JMSException;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.server.JMSServer;
import jeus.jms.server.manager.DestinationFactory;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.persistence.CommonArchive;
import jeus.jms.server.persistence.DestinationRecoveryListener;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.DestinationType;

public class DestinationArchive
extends CommonArchive
implements DestinationRecoveryListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public DestinationArchive(Storage storage) throws Exception {
        super(storage);
    }

    public void init() throws Exception {
        super.init();
        this.storage.recover(this);
    }

    public void recovered(long id, JeusDestination destination) {
        block7: {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5621_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5621_LEVEL, JeusMessage_JMS5._5621, new Long(id));
            }
            this.sequencer.set(Math.max(this.sequencer.get(), id));
            String name = destination.getLocalName();
            try {
                DestinationType descriptor = JMSServer.getJMSServer().getDescriptor().findDestination(name);
                if (descriptor != null) {
                    JeusDestination newDestination = DestinationFactory.createDestination(descriptor);
                    if (newDestination.getType() != destination.getType()) {
                        destination.setValid(false);
                    } else {
                        newDestination.setId(destination.getId());
                        newDestination.setVersion(destination.getVersion());
                        newDestination.setRecovered(true);
                        destination = newDestination;
                        this.update(destination);
                    }
                } else {
                    destination.setValid(false);
                }
                DestinationUtil.restoreDestinationManager(destination);
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5622_LEVEL)) break block7;
                LogUtils.log(logger, JeusMessage_JMS5._5622_LEVEL, JeusMessage_JMS5._5622, new Long(id));
            }
        }
    }

    public void beginRecovery() {
    }

    public void endRecovery() throws Exception {
    }

    public void update(JeusDestination destination) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5623_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5623_LEVEL, JeusMessage_JMS5._5623, new Long(destination.getId()));
        }
        try {
            this.storage.update(destination);
        }
        catch (StorageException e) {
            logger.directLog("failed to update destination", (Throwable)((Object)e));
        }
    }

    public void persist(JeusDestination destination) throws StorageException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5624_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5624_LEVEL, JeusMessage_JMS5._5624, destination.toString());
        }
        this.storage.persist(destination);
    }

    public void delete(JeusDestination destination) {
        block3: {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5625_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5625_LEVEL, JeusMessage_JMS5._5625, new Long(destination.getId()));
            }
            try {
                this.storage.deleteDestination(destination);
            }
            catch (Exception e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5626_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._5626_LEVEL, JeusMessage_JMS5._5626, e);
            }
        }
    }
}

