/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import jeus.jms.common.JMSProperties;
import jeus.jms.server.JMSServer;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.CommonArchive;
import jeus.jms.server.persistence.MessageRecoveryListener;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageCursor;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.util.concurrent.SynchronizedLong;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class MessageArchive
extends CommonArchive
implements MessageRecoveryListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.persistence");
    private SynchronizedLong entryId = new SynchronizedLong(0L);
    private Map restored;
    private long beginTime;
    private int total = 0;
    private int failed = 0;

    public MessageArchive(Storage storage) throws Exception {
        super(storage);
    }

    public long createMessageID(byte type) {
        return this.sequencer.increment();
    }

    public long getNextEntryID() {
        return this.entryId.increment();
    }

    public void init() throws Exception {
        super.init();
        this.storage.recover(this);
    }

    public void shutdownAll() {
        super.shutdownAll();
        if (this.restored != null) {
            this.restored.clear();
            this.restored = null;
        }
    }

    public void recovered(long id, long destinationId, long version, ServerMessage message, byte lifeCycle) {
        block9: {
            ++this.total;
            this.sequencer.set(Math.max(this.sequencer.get(), id));
            this.entryId.set(Math.max(this.entryId.get(), message.getMessageID().getEntryID()));
            try {
                DestinationManager mgr = DestinationUtil.getDestinationManager(destinationId);
                if (version != mgr.getDestination().getVersion()) {
                    if (this.total % JMSProperties.ROW_FETCH_SIZE == 0) {
                        this.logRecoveryResult("recovered");
                    }
                    return;
                }
            }
            catch (InvalidDestinationException e) {
                ++this.failed;
                if (this.total % JMSProperties.ROW_FETCH_SIZE == 0) {
                    this.logRecoveryResult("recovered");
                }
                return;
            }
            if (!JMSServer.isSAFEngine()) {
                message.setLocalConsume(true);
            }
            message.setMessageArchive(this);
            try {
                this.recoverMessage(destinationId, message, lifeCycle);
                this.restored.put(new Long(id), message);
            }
            catch (Exception e) {
                ++this.failed;
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5591_LEVEL)) break block9;
                LogUtils.log(logger, JeusMessage_JMS5._5591_LEVEL, JeusMessage_JMS5._5591, e);
            }
        }
        if (this.total % JMSProperties.ROW_FETCH_SIZE == 0) {
            this.logRecoveryResult("recovered");
        }
    }

    public void recovered(long messageId, long durableSubscriberId, byte lifeCycle) {
        block4: {
            ServerMessage message = (ServerMessage)this.restored.get(new Long(messageId));
            if (message == null) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5592_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5592_LEVEL, JeusMessage_JMS5._5592, new Long(messageId));
                }
                return;
            }
            try {
                this.recoverDurableMessage(durableSubscriberId, message, lifeCycle);
            }
            catch (InvalidDestinationException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5593_LEVEL)) break block4;
                LogUtils.log(logger, JeusMessage_JMS5._5593_LEVEL, JeusMessage_JMS5._5593, e);
            }
        }
    }

    private void logRecoveryResult(String module) {
        int succeed = this.restored.size();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5594_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5594_LEVEL, JeusMessage_JMS5._5594, new Object[]{module, new Integer(this.total), new Integer(succeed), new Integer(this.total - succeed - this.failed), new Integer(this.failed), new Long(System.currentTimeMillis() - this.beginTime)});
        }
    }

    public void beginRecovery() {
        this.beginTime = System.currentTimeMillis();
        this.restored = new HashMap();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5595_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5595_LEVEL, JeusMessage_JMS5._5595);
        }
    }

    public void endRecovery() throws Exception {
        this.logRecoveryResult("endRecovery");
        this.restored.clear();
        this.restored = null;
    }

    public StorageCursor createStorageCursor(ServerMessage message) {
        return this.storage.createStorageCursor(message);
    }

    public boolean enqueue(long messageId) {
        return this.storage.enqueued(messageId);
    }

    public boolean enqueue(long messageId, long durableSubscriberId, boolean recovered) {
        return this.storage.enqueue(messageId, durableSubscriberId, recovered);
    }

    public boolean distributed(long messageId) {
        return this.storage.distributed(messageId);
    }

    public boolean dispatched(long messageId) {
        return this.storage.dispatched(messageId);
    }

    public boolean dispatched(long messageId, long targetId) {
        return this.storage.dispatched(messageId, targetId);
    }

    public void prepareProduce(StorageTransactionContext context, long destinationId, long version, ServerMessage message, byte lifeCycle) throws StorageException {
        this.storage.prepareProduce(context, destinationId, version, message, lifeCycle);
    }

    public boolean prepareConsume(StorageTransactionContext context, long messageId) throws StorageException {
        return this.storage.prepareConsume(context, messageId);
    }

    public boolean prepareConsume(StorageTransactionContext context, long messageId, long durableSubscriberId) throws StorageException {
        return this.storage.prepareConsume(context, messageId, durableSubscriberId);
    }

    public boolean completed(long messageId, boolean queue) {
        return this.storage.completed(messageId, queue);
    }

    public boolean completed(long messageId, long durableSubscriberId) {
        return this.storage.completed(messageId, durableSubscriberId);
    }

    public boolean expired(long messageId, boolean queue) {
        return this.storage.expired(messageId, queue);
    }

    public boolean deleteMessage(long messageId, boolean queue) throws StorageException {
        this.storage.deleteMessage(messageId, queue);
        return true;
    }

    private void recoverMessage(long destinationId, ServerMessage message, byte lifeCycle) throws Exception {
        block3: {
            try {
                DestinationManager manager = DestinationUtil.getDestinationManager(destinationId);
                manager.recoveredProduce(message, lifeCycle);
                if (lifeCycle == 16) {
                    this.deleteMessage(message.getId(), manager.isQueue());
                }
            }
            catch (Exception e) {
                if (lifeCycle == 16) break block3;
                throw e;
            }
        }
    }

    private void recoverDurableMessage(long subscriptionId, ServerMessage message, byte lifeCycle) throws InvalidDestinationException {
        block2: {
            try {
                SubscriptionManager manager = SubscriptionUtil.getSubscriptionManager(subscriptionId);
                manager.recoveredConsume(message, lifeCycle);
            }
            catch (InvalidDestinationException e) {
                if (lifeCycle == 16) break block2;
                throw e;
            }
        }
    }
}

