/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence;

import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.persistence.NullStorageCreator;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.database.DatabaseStorageCreator;
import jeus.util.logging.JeusLogger;
import jeus.xml.binding.jeusDD.StorageType;

public abstract class StorageCreator {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.persistence");

    public static StorageCreator createStorageCreator(StorageType storageType) throws Exception {
        if (storageType != null && storageType.isSetDbStorage()) {
            return DatabaseStorageCreator.createDatabaseStorageCreator(storageType, ClusterManager.LOCAL_BROKER_NAME);
        }
        return new NullStorageCreator();
    }

    public abstract Storage createStorage() throws Exception;

    public boolean needRecovery() {
        return false;
    }
}

