/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.File;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import jeus.jms.common.JMSEnvironmentValues;
import jeus.jms.common.JMSProperties;
import jeus.jms.server.JMSServer;
import jeus.jms.server.persistence.ReliabilityLevel;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageCreator;
import jeus.jms.server.persistence.database.DatabaseConstants;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.DerbyPlatform;
import jeus.jms.server.persistence.database.LongString;
import jeus.jms.server.util.JaxbUtil;
import jeus.util.JeusProperties;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.DbStorageType;
import jeus.xml.binding.jeusDD.EmbeddedType;
import jeus.xml.binding.jeusDD.StorageType;

public class DatabaseStorageCreator
extends StorageCreator
implements DatabaseConstants {
    private final DataSource dataSource;
    private String destinationTableName;
    private String durableSubscriberTableName;
    private String messageTableName;
    private String userPropertyTableName;
    private String durableMessageTableName;
    private String xaTableName;
    private boolean needRecovery = true;
    private boolean deleteInvalidDestinations;
    private long sqlPollTimeout;
    private boolean waitSqlExecutor;
    private ReliabilityLevel level;

    public DatabaseStorageCreator(DataSource ds, String brokerName, String destinationTableName, String durableSubscriberTableName, String messageTableName, String userPropertyTableName, String durableMessageTableName, String xaTableName, boolean deleteInvalidDestintions, long sqlPollTimeout, boolean waitSqlExecutor, ReliabilityLevel level) throws Exception {
        this.dataSource = ds;
        this.deleteInvalidDestinations = deleteInvalidDestintions;
        this.sqlPollTimeout = sqlPollTimeout;
        this.waitSqlExecutor = waitSqlExecutor;
        this.level = level;
        this.init(brokerName, destinationTableName, durableSubscriberTableName, messageTableName, userPropertyTableName, durableMessageTableName, xaTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String brokerName, String destinationTableName, String durableSubscriberTableName, String messageTableName, String userPropertyTableName, String durableMessageTableName, String xaTableName) throws Exception {
        if (destinationTableName == null) {
            destinationTableName = brokerName + "_" + "DESTINATION";
        }
        if (durableSubscriberTableName == null) {
            durableSubscriberTableName = brokerName + "_" + "DURSUBSCRIBER";
        }
        if (messageTableName == null) {
            messageTableName = brokerName + "_" + "MESSAGE";
        }
        if (userPropertyTableName == null) {
            userPropertyTableName = brokerName + "_" + "USRPROPERTY";
        }
        if (durableMessageTableName == null) {
            durableMessageTableName = brokerName + "_" + "DURMESSAGE";
        }
        if (xaTableName == null) {
            xaTableName = brokerName + "_" + "XA";
        }
        this.destinationTableName = destinationTableName.toUpperCase();
        this.durableSubscriberTableName = durableSubscriberTableName.toUpperCase();
        this.messageTableName = messageTableName.toUpperCase();
        this.userPropertyTableName = userPropertyTableName.toUpperCase();
        this.durableMessageTableName = durableMessageTableName.toUpperCase();
        this.xaTableName = xaTableName.toUpperCase();
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            String productName = metaData.getDatabaseProductName();
            String productVersion = metaData.getDatabaseProductVersion();
            String driverName = metaData.getDriverName();
            String driverVersion = metaData.getDriverVersion();
            DatabasePlatform platform = DatabasePlatform.getPlatform(this.dataSource, conn, productName);
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5211_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5211_LEVEL, JeusMessage_JMS5._5211, new Object[]{productName, productVersion, driverName, driverVersion});
            }
            if (JMSProperties.DELETE_TABLES_ON_START) {
                this.deleteTables(conn, platform);
            }
            if (!platform.checkTable(this.destinationTableName, conn)) {
                this.createDestinationTable(conn, platform);
                this.needRecovery = false;
            }
            if (!platform.checkTable(this.durableSubscriberTableName, conn)) {
                this.createDurableSubscriberTable(conn, platform);
                this.needRecovery = false;
            }
            if (!platform.checkTable(this.messageTableName, conn)) {
                this.createMessageTable(conn, platform);
                this.needRecovery = false;
            }
            if (!platform.checkTable(this.userPropertyTableName, conn)) {
                this.createUserPropertyTable(conn, platform);
                this.needRecovery = false;
            }
            if (!platform.checkTable(this.durableMessageTableName, conn)) {
                this.createDurableMessageTable(conn, platform);
                this.needRecovery = false;
            }
            if (!platform.checkTable(this.xaTableName, conn)) {
                this.createXATable(conn, platform);
                this.needRecovery = false;
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5212_LEVEL)) {
                        LogUtils.log(logger, JeusMessage_JMS5._5212_LEVEL, JeusMessage_JMS5._5212, ex.getMessage(), (Throwable)ex);
                    }
                    throw ex;
                }
            }
        }
    }

    private void deleteTables(Connection conn, DatabasePlatform platform) throws Exception {
        this.deleteTable(conn, platform, this.durableMessageTableName);
        this.deleteTable(conn, platform, this.durableSubscriberTableName);
        this.deleteTable(conn, platform, this.userPropertyTableName);
        this.deleteTable(conn, platform, this.messageTableName);
        this.deleteTable(conn, platform, this.destinationTableName);
        this.deleteTable(conn, platform, this.xaTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTable(Connection conn, DatabasePlatform platform, String tableName) throws Exception {
        if (platform.checkTable(tableName, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.executeUpdate("DROP TABLE " + tableName);
            }
            finally {
                stmt.close();
            }
        }
    }

    public static StringBuffer addColumn(DatabasePlatform platform, StringBuffer buffer, String name, Class type) {
        return DatabaseStorageCreator.addColumn(platform, buffer, name, type, true, null);
    }

    public static StringBuffer addColumn(DatabasePlatform platform, StringBuffer buffer, String name, Class type, boolean notNull) {
        return DatabaseStorageCreator.addColumn(platform, buffer, name, type, notNull, null);
    }

    public static StringBuffer addColumn(DatabasePlatform platform, StringBuffer buffer, String name, Class type, boolean notNull, String defaultValue) {
        return DatabaseStorageCreator.addColumn(platform, buffer, name, type, notNull, defaultValue, false);
    }

    public static StringBuffer addColumn(DatabasePlatform platform, StringBuffer buffer, String name, Class type, boolean notNull, String defaultValue, boolean last) {
        buffer.append(name).append(" ").append(platform.getTypeName(type));
        if (notNull) {
            buffer.append(" NOT NULL");
        }
        if (defaultValue != null) {
            buffer.append(" DEFAULT ").append(defaultValue);
        }
        if (!last) {
            buffer.append(", ");
        }
        return buffer;
    }

    private void createDestinationTable(Connection conn, DatabasePlatform platform) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5213_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5213_LEVEL, JeusMessage_JMS5._5213, this.destinationTableName);
        }
        String primaryKeyName = (this.destinationTableName + "_PK").toUpperCase();
        StringBuffer sql = new StringBuffer(256);
        sql.append("CREATE TABLE ").append(this.destinationTableName).append(" ( ");
        DatabaseStorageCreator.addColumn(platform, sql, "DT_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_NAME", String.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_EXPORT_NAME", String.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_TYPE", Byte.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_BROKER_NAME", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_CONSUMER_LIMIT", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_CAPACITY_LOW_MARK", Long.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_CAPACITY_HIGH_MARK", Long.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_CAPACITY_LIMIT", Long.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_WEIGHT", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_DISTRIBUTE_TYPE", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_LOCAL_DISTRIBUTE_TYPE", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_MULTIPLE_RECEIVER", Boolean.class, false, platform.getFalse());
        DatabaseStorageCreator.addColumn(platform, sql, "DT_MAX_PENDING_LIMIT", Integer.class, false, String.valueOf(Integer.MAX_VALUE));
        DatabaseStorageCreator.addColumn(platform, sql, "DT_RESUME_DISPATCH_FACTOR", Float.class, false, String.valueOf(0.4f));
        DatabaseStorageCreator.addColumn(platform, sql, "DT_RELAY_TYPE", Byte.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_RELAYS", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_VALID", Boolean.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_VERSION", Long.class);
        sql.append("CONSTRAINT ").append(primaryKeyName).append(" PRIMARY KEY(DT_ID)");
        sql.append(")");
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5214_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5214_LEVEL, JeusMessage_JMS5._5214, sql);
        }
        this.execute(sql.toString(), conn);
    }

    protected void createDurableSubscriberTable(Connection conn, DatabasePlatform platform) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5215_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5215_LEVEL, JeusMessage_JMS5._5215, this.durableSubscriberTableName);
        }
        String primaryKeyName = (this.durableSubscriberTableName + "_PK").toUpperCase();
        String uniqueKeyName = (this.durableSubscriberTableName + "_UK").toUpperCase();
        String foriegnKeyName = (this.durableSubscriberTableName + "_FK").toUpperCase();
        StringBuffer sql = new StringBuffer(256);
        sql.append("CREATE TABLE ").append(this.durableSubscriberTableName).append(" ( ");
        DatabaseStorageCreator.addColumn(platform, sql, "DS_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DS_CLIENT_ID", String.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DS_DURABLE_NAME", String.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DS_NOLOCAL", Boolean.class, false, platform.getFalse());
        DatabaseStorageCreator.addColumn(platform, sql, "DS_SELECTOR", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "DS_CLUSTER", Boolean.class, false, platform.getFalse());
        sql.append("CONSTRAINT ").append(primaryKeyName).append(" PRIMARY KEY(DS_ID),");
        sql.append("CONSTRAINT ").append(uniqueKeyName).append(" UNIQUE(DS_CLIENT_ID,DS_DURABLE_NAME),");
        sql.append("CONSTRAINT ").append(foriegnKeyName).append(" FOREIGN KEY(DT_ID) ").append("REFERENCES ").append(this.destinationTableName).append("(DT_ID)");
        sql.append(")");
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5216_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5216_LEVEL, JeusMessage_JMS5._5216, sql.toString());
        }
        this.execute(sql.toString(), conn);
    }

    private void createMessageTable(Connection conn, DatabasePlatform platform) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5217_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5217_LEVEL, JeusMessage_JMS5._5217, this.messageTableName);
        }
        String primaryKeyName = (this.messageTableName + "_PK").toUpperCase();
        String dtForeignKeyName = (this.messageTableName + "_DT_FK").toUpperCase();
        String txForeignKeyName = (this.messageTableName + "_TX_FK").toUpperCase();
        String rtForeignKeyName = (this.messageTableName + "_RT_FK").toUpperCase();
        StringBuffer sql = new StringBuffer(256);
        sql.append("CREATE TABLE ").append(this.messageTableName).append(" ( ");
        DatabaseStorageCreator.addColumn(platform, sql, "MG_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DT_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_MESSAGE_TYPE", Byte.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_STATUS", Byte.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_BROKER_ID", Short.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_ENTRY_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_CONNECTION_ID", Integer.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_SEQUENCE", Integer.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_META_INFO", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_CORRELATION_ID", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TD_REPLY_TO", Long.class, false, "-1");
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TD_TYPE", Byte.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TD_BROKER_NAME", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TD_NAME", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TD_CONNECTION_ID", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_REPLY_TO", Long.class, false, "-1");
        DatabaseStorageCreator.addColumn(platform, sql, "MG_DELIVERY_MODE", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TYPE", String.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_PRIORITY", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_EXPIRATION", Long.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_TIMESTAMP", Long.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_SCHEDULE", Long.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_REDELIVERY_LIMIT", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_HAS_LONG_USER_PROPS", Boolean.class, false, platform.getFalse());
        DatabaseStorageCreator.addColumn(platform, sql, "MG_USER_PROPERTIES", LongString.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_LIFECYCLE", Byte.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_CONTENT_LENGTH", Integer.class);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_CONTENT", Blob.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "MG_VERSION", Long.class);
        sql.append("CONSTRAINT ").append(primaryKeyName).append(" PRIMARY KEY(MG_ID), ");
        sql.append("CONSTRAINT ").append(dtForeignKeyName).append(" FOREIGN KEY(DT_ID) ").append("REFERENCES ").append(this.destinationTableName).append("(DT_ID), ");
        sql.append("CONSTRAINT ").append(rtForeignKeyName).append(" FOREIGN KEY(MG_REPLY_TO) ").append("REFERENCES ").append(this.destinationTableName).append("(DT_ID)");
        sql.append(")");
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5218_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5218_LEVEL, JeusMessage_JMS5._5218, sql.toString());
        }
        this.execute(sql.toString(), conn);
    }

    private void createUserPropertyTable(Connection conn, DatabasePlatform platform) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5219_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5219_LEVEL, JeusMessage_JMS5._5219, this.userPropertyTableName);
        }
        String upPrimaryKeyName = (this.userPropertyTableName + "_PK").toUpperCase();
        String upForeignKeyName = (this.userPropertyTableName + "_FK").toUpperCase();
        StringBuffer sql = new StringBuffer(256);
        sql.append("CREATE TABLE ").append(this.userPropertyTableName).append(" ( ");
        DatabaseStorageCreator.addColumn(platform, sql, "MG_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_NAME", String.class);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_TYPE", Byte.class);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_BOOLEAN", Boolean.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_BYTE", Byte.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_SHORT", Short.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_INT", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_LONG", Integer.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_FLOAT", Float.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_DOUBLE", Double.class, false);
        DatabaseStorageCreator.addColumn(platform, sql, "UP_STRING", String.class, false);
        sql.append("CONSTRAINT ").append(upPrimaryKeyName).append(" PRIMARY KEY(MG_ID,UP_NAME), ");
        sql.append("CONSTRAINT ").append(upForeignKeyName).append(" FOREIGN KEY(MG_ID) ").append("REFERENCES ").append(this.messageTableName).append("(MG_ID) ON DELETE CASCADE");
        sql.append(")");
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5220_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5220_LEVEL, JeusMessage_JMS5._5220, sql.toString());
        }
        this.execute(sql.toString(), conn);
    }

    private void createDurableMessageTable(Connection conn, DatabasePlatform platform) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5221_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5221_LEVEL, JeusMessage_JMS5._5221, this.durableMessageTableName);
        }
        String primaryKeyName = (this.durableMessageTableName + "_PK").toUpperCase();
        String dsForeignKeyName = (this.durableMessageTableName + "_DS_FK").toUpperCase();
        String mgForiegnKeyName = (this.durableMessageTableName + "_MG_FK").toUpperCase();
        StringBuffer sql = new StringBuffer(256);
        sql.append("CREATE TABLE ").append(this.durableMessageTableName).append(" ( ");
        DatabaseStorageCreator.addColumn(platform, sql, "MG_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DS_ID", Long.class);
        DatabaseStorageCreator.addColumn(platform, sql, "DM_LIFECYCLE", Byte.class);
        sql.append("CONSTRAINT ").append(primaryKeyName).append(" PRIMARY KEY(MG_ID, DS_ID),");
        sql.append("CONSTRAINT ").append(mgForiegnKeyName).append(" FOREIGN KEY(MG_ID) ").append("REFERENCES ").append(this.messageTableName).append("(MG_ID) ON DELETE CASCADE,");
        sql.append("CONSTRAINT ").append(dsForeignKeyName).append(" FOREIGN KEY(DS_ID) ").append("REFERENCES ").append(this.durableSubscriberTableName).append("(DS_ID) ");
        sql.append(")");
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5222_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5222_LEVEL, JeusMessage_JMS5._5222, sql.toString());
        }
        this.execute(sql.toString(), conn);
    }

    private void createXATable(Connection conn, DatabasePlatform platform) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5223_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5223_LEVEL, JeusMessage_JMS5._5223, this.xaTableName);
        }
        String primaryKeyName = (this.xaTableName + "_PK").toUpperCase();
        StringBuffer sql = new StringBuffer(256);
        sql.append("CREATE TABLE ").append(this.xaTableName).append(" ( ");
        DatabaseStorageCreator.addColumn(platform, sql, "XA_ID", Integer.class);
        DatabaseStorageCreator.addColumn(platform, sql, "XA_STARTTIME", Timestamp.class);
        DatabaseStorageCreator.addColumn(platform, sql, "XA_PREPARED", Boolean.class);
        DatabaseStorageCreator.addColumn(platform, sql, "XA_XID", Byte[].class);
        sql.append("CONSTRAINT ").append(primaryKeyName).append(" PRIMARY KEY(XA_ID)");
        sql.append(")");
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5224_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5224_LEVEL, JeusMessage_JMS5._5224, sql.toString());
        }
        this.execute(sql.toString(), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql, Connection conn) throws SQLException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5225_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5225_LEVEL, JeusMessage_JMS5._5225, sql);
        }
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    public static DatabaseStorageCreator createDatabaseStorageCreator(StorageType descriptor, String brokerName) throws Exception {
        DataSource ds;
        DbStorageType dbDescriptor = descriptor.getDbStorage();
        String dbExportName = dbDescriptor.getDataSourceName();
        if (dbDescriptor.isSetEmbedded()) {
            String dbPath;
            File f;
            EmbeddedType embeddedDescriptor;
            String dbName = JMSServer.isSAFEngine() ? JMSEnvironmentValues.getClientEmbeddedDBDir() : ((embeddedDescriptor = dbDescriptor.getEmbedded()).isSetPath() ? (!(f = new File(dbPath = embeddedDescriptor.getPath())).isAbsolute() ? JeusProperties.JEUS_LOG_HOME + File.separator + "jms" + File.separator + dbPath : dbPath) : JMSEnvironmentValues.getServerEmbeddedDBDir());
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5226_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5226_LEVEL, JeusMessage_JMS5._5226);
            }
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5227_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5227_LEVEL, JeusMessage_JMS5._5227, dbName);
            }
            ds = DerbyPlatform.getEmbeddedDataSource(dbName);
        } else {
            InitialContext ctx = new InitialContext();
            ds = (DataSource)ctx.lookup(dbExportName);
        }
        return new DatabaseStorageCreator(ds, brokerName, dbDescriptor.getDestinationTableName(), dbDescriptor.getDurableSubscriberTableName(), dbDescriptor.getMessageTableName(), dbDescriptor.getUserPropertyTableName(), dbDescriptor.getDurableMessageTableName(), dbDescriptor.getXaTableName(), JaxbUtil.getWithDefault(descriptor.isDeleteInvalidDestinations(), descriptor.getDefaultDeleteInvalidDestinations()), JaxbUtil.getWithDefault(dbDescriptor.getSqlPollTimeout(), dbDescriptor.getDefaultSqlPollTimeout()), JaxbUtil.getWithDefault(dbDescriptor.isWaitSqlExecutor(), dbDescriptor.getDefaultWaitSqlExecutor()), ReliabilityLevel.getReliabilityLevel(JaxbUtil.getWithDefault(descriptor.getReliabilityLevel(), descriptor.getDefaultReliabilityLevel()).value()));
    }

    public Storage createStorage() throws Exception {
        return new DatabaseStorage(this.dataSource, this.destinationTableName, this.durableSubscriberTableName, this.messageTableName, this.userPropertyTableName, this.durableMessageTableName, this.xaTableName, this.deleteInvalidDestinations, this.sqlPollTimeout, this.waitSqlExecutor, this.level);
    }

    public boolean needRecovery() {
        return this.needRecovery;
    }
}

