/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.database.LongString;
import jeus.jms.server.persistence.database.ManagedDatabasePlatform;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.sql.BLOB;

class OraclePlatform
extends ManagedDatabasePlatform {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTable(String name, Connection con) throws SQLException {
        boolean exists;
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT TNAME FROM TAB WHERE TNAME='" + name + "'");
            exists = rs.next();
        }
        finally {
            stmt.close();
        }
        return exists;
    }

    protected Map buildTypeNames() {
        HashMap<Class, String> fieldTypeMapping = new HashMap<Class, String>();
        fieldTypeMapping.put(Boolean.class, "NUMBER(1)");
        fieldTypeMapping.put(Integer.class, "NUMBER(10)");
        fieldTypeMapping.put(Long.class, "NUMBER(19)");
        fieldTypeMapping.put(Float.class, "NUMBER(19,4)");
        fieldTypeMapping.put(Double.class, "NUMBER(19,4)");
        fieldTypeMapping.put(Short.class, "NUMBER(5)");
        fieldTypeMapping.put(Byte.class, "NUMBER(3)");
        fieldTypeMapping.put(BigInteger.class, "NUMBER(38)");
        fieldTypeMapping.put(BigDecimal.class, "NUMBER(38)");
        fieldTypeMapping.put(Number.class, "NUMBER(38)");
        fieldTypeMapping.put(LongString.class, "VARCHAR(" + this.getMaxStringLength() + ")");
        fieldTypeMapping.put(String.class, "VARCHAR2(255)");
        fieldTypeMapping.put(Character.class, "CHAR(1)");
        fieldTypeMapping.put(Byte[].class, "BLOB");
        fieldTypeMapping.put(Character[].class, "CLOB");
        fieldTypeMapping.put(byte[].class, "BLOB");
        fieldTypeMapping.put(char[].class, "CLOB");
        fieldTypeMapping.put(Blob.class, "BLOB");
        fieldTypeMapping.put(Clob.class, "CLOB");
        fieldTypeMapping.put(Date.class, "DATE");
        fieldTypeMapping.put(Time.class, "DATE");
        fieldTypeMapping.put(Timestamp.class, "DATE");
        return fieldTypeMapping;
    }

    protected Map buildSqlTypes() {
        HashMap<Class<Time>, Integer> sqlTypeMapping = new HashMap<Class<Time>, Integer>();
        sqlTypeMapping.put(Boolean.class, new Integer(2));
        sqlTypeMapping.put(Integer.class, new Integer(2));
        sqlTypeMapping.put(Long.class, new Integer(2));
        sqlTypeMapping.put(Float.class, new Integer(2));
        sqlTypeMapping.put(Double.class, new Integer(2));
        sqlTypeMapping.put(Short.class, new Integer(2));
        sqlTypeMapping.put(Byte.class, new Integer(2));
        sqlTypeMapping.put(BigInteger.class, new Integer(2));
        sqlTypeMapping.put(BigDecimal.class, new Integer(2));
        sqlTypeMapping.put(LongString.class, new Integer(12));
        sqlTypeMapping.put(String.class, new Integer(12));
        sqlTypeMapping.put(Character.class, new Integer(1));
        sqlTypeMapping.put(Byte[].class, new Integer(2004));
        sqlTypeMapping.put(Character[].class, new Integer(2005));
        sqlTypeMapping.put(byte[].class, new Integer(2004));
        sqlTypeMapping.put(char[].class, new Integer(2005));
        sqlTypeMapping.put(Blob.class, new Integer(2004));
        sqlTypeMapping.put(Clob.class, new Integer(2005));
        sqlTypeMapping.put(Date.class, new Integer(91));
        sqlTypeMapping.put(Timestamp.class, new Integer(91));
        sqlTypeMapping.put(Time.class, new Integer(91));
        return sqlTypeMapping;
    }

    public void writeBlobData(Blob blob, byte[] data) throws Exception {
        BLOB oracleBlob = (BLOB)blob;
        OutputStream output = oracleBlob.getBinaryOutputStream(1L);
        output.write(data);
        output.flush();
        output.close();
    }

    public void setEmptyBlob(PreparedStatement stmt, int index) throws SQLException {
        stmt.setBlob(index, (Blob)BLOB.empty_lob());
    }

    public boolean canSetBytes(byte[] data) {
        return data.length <= 4000;
    }

    public int getMaxStringLength() {
        return 4000;
    }

    public void handleXAException(XAException e) {
        if (e instanceof OracleXAException) {
            OracleXAException orae = (OracleXAException)e;
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5291_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5291_LEVEL, JeusMessage_JMS5._5291, new Object[]{new Integer(orae.getXAError()), OracleXAException.getXAErrorMessage((int)orae.getXAError())});
            }
        }
    }

    public Xid createXid(Xid xid) throws XAException {
        if (xid instanceof JMSXid && ((JMSXid)xid).getSourceXid() != null) {
            return ((JMSXid)xid).getSourceXid();
        }
        return new OracleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public Xid[] recover(GlobalTransactionContext context) throws XAException {
        if (this.majorDatabaseVersion == this.majorDriverVersion) {
            return context.recover(0x1000000);
        }
        throw new XAException("Oracle database major version and driver major version is mismatch.");
    }

    public void exclusiveLockOnTable(Connection conn, String tableName) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("LOCK TABLE " + tableName + " IN EXCLUSIVE MODE ");
        stmt.close();
    }

    public void setDebug(boolean enable, String level) {
        block9: {
            try {
                switch (this.majorDriverVersion) {
                    case 7: 
                    case 8: 
                    case 9: {
                        if (enable) {
                            OracleLog.startLogging();
                            break;
                        }
                        OracleLog.stopLogging();
                        break;
                    }
                    default: {
                        if (enable) {
                            if (level == null) {
                                this.setLogLevel(Level.FINEST);
                            } else {
                                this.setLogLevel(Level.parse(level));
                            }
                            OracleLog.setTrace((boolean)true);
                            break;
                        }
                        this.setLogLevel(Level.SEVERE);
                        OracleLog.setTrace((boolean)false);
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._5292_LEVEL)) break block9;
                LogUtils.log(logger, JeusMessage_JMS5._5292_LEVEL, JeusMessage_JMS5._5292, e);
            }
        }
    }

    private void setLogLevel(Level level) {
        Logger.getLogger("oracle.jdbc").setLevel(level);
        Logger.getLogger("oracle.jdbc.driver").setLevel(level);
        Logger.getLogger("oracle.jdbc.pool").setLevel(level);
        Logger.getLogger("oracle.jdbc.conversion").setLevel(level);
        Logger.getLogger("oracle.jdbc.adt").setLevel(level);
        Logger.getLogger("oracle.jdbc.thin").setLevel(level);
        Logger.getLogger("oracle.jdbc.datum").setLevel(level);
        Logger.getLogger("oracle.jdbc.kprb").setLevel(level);
        Logger.getLogger("oracle.jdbc.xa").setLevel(level);
        Logger.getLogger("oracle.jdbc.sqlj").setLevel(level);
        Logger.getLogger("oracle.jdbc.oci").setLevel(level);
        Logger.getLogger("oracle.jdbc.jpub").setLevel(level);
    }
}

