/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.Statement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;
import jeus.util.concurrent50.concurrent.BlockingQueue;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class BatchDeleteMessagesCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "BATCH_DELETE_MESSAGES";
    private long[] idArray;
    private int length;

    public BatchDeleteMessagesCommand(DatabaseStorage storage, long[] idArray, int length) {
        super(storage);
        this.idArray = idArray;
        this.length = length;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getMessageTableName()).append(" WHERE ");
        buffer.append("MG_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < this.length; ++i) {
            buffer.append(this.idArray[i]);
            if (i >= this.length - 1) continue;
            buffer.append(",");
        }
        buffer.append(")");
        return new SQLParameter[]{new SQLParameter("MG_ID", buffer.toString())};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public boolean retry() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getMessageTableName()).append(" WHERE ");
        for (int i = 0; i < this.length; ++i) {
            buffer.append("MG_ID").append("=").append(this.idArray[i]);
            if (i + 1 >= this.length) continue;
            buffer.append(" OR ");
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5501_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5501_LEVEL, JeusMessage_JMS5._5501, new Object[]{COMMAND_NAME, buffer.toString()});
        }
        Statement stmt = connection.createStatement();
        try {
            stmt.executeUpdate(buffer.toString());
        }
        finally {
            stmt.close();
        }
    }

    public void recover(BlockingQueue queue) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5502_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5502_LEVEL, JeusMessage_JMS5._5502);
        }
        for (int i = 0; i < this.length; ++i) {
            queue.offer((Object)new Long(this.idArray[i]));
        }
    }
}

