/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.BooleanSQLCommand;

public class CheckDurableMessageCommand
extends BooleanSQLCommand {
    public static final String COMMAND_NANE = "CHECK_DURABLE_MESSAGE_COMMAND";
    private long messageId;
    private long durableSubscriberId;
    private boolean exists;

    public CheckDurableMessageCommand(DatabaseStorage storage, long messageId, long durableSubscriberId) {
        super(storage);
        this.messageId = messageId;
        this.durableSubscriberId = durableSubscriberId;
    }

    protected String createSQL() {
        DatabasePlatform platform = this.storage.getDatabasePlatform();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("DM_LIFECYCLE");
        buffer.append(" FROM ").append(this.storage.getDurableMessageTableName());
        buffer.append(" WHERE ");
        buffer.append("MG_ID").append("=? AND ");
        buffer.append("DS_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_ID", String.valueOf(this.messageId)), new SQLParameter("DS_ID", String.valueOf(this.durableSubscriberId))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.messageId);
            stmt.setLong(2, this.durableSubscriberId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                this.exists = true;
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NANE;
    }

    public boolean isTrue() {
        return this.exists;
    }
}

