/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageProperty;
import jeus.jms.common.util.DataSqueezer;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.BlobSQLCommand;
import jeus.jms.server.persistence.database.command.InsertUserPropertiesCommand;
import jeus.jms.server.util.MessageLifecycle;
import jeus.nio.ByteBufferWrapper;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class InsertMessageCommand
extends BlobSQLCommand {
    private static final boolean NEED_LOGGING = logger.isLoggable(Level.FINEST);
    public static final String COMMAND_NAME = "INSERT_MESSAGE";
    private static String BLOB_SQL;
    private ServerMessage message;
    private long destinationId;
    private long version;
    private byte lifeCycle;
    private boolean hasLongProps;

    public InsertMessageCommand(DatabaseStorage storage, long destinationId, long version, ServerMessage message, byte lifeCycle) {
        super(storage);
        this.destinationId = destinationId;
        this.version = version;
        this.message = message;
        this.lifeCycle = lifeCycle;
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_ID", String.valueOf(this.message.getId())), new SQLParameter("DT_ID", String.valueOf(this.destinationId)), new SQLParameter("MG_MESSAGE_TYPE", String.valueOf(this.message.getMessageType())), new SQLParameter("MG_STATUS", String.valueOf(this.message.getMessageID().getStatus())), new SQLParameter("MG_LIFECYCLE", MessageLifecycle.getStringValue(this.lifeCycle))};
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(this.storage.getMessageTableName()).append("(");
        buffer.append("MG_ID").append(", ");
        buffer.append("DT_ID").append(", ");
        buffer.append("MG_MESSAGE_TYPE").append(", ");
        buffer.append("MG_STATUS").append(", ");
        buffer.append("MG_BROKER_ID").append(", ");
        buffer.append("MG_ENTRY_ID").append(", ");
        buffer.append("MG_CONNECTION_ID").append(", ");
        buffer.append("MG_SEQUENCE").append(", ");
        buffer.append("MG_META_INFO").append(", ");
        buffer.append("MG_CORRELATION_ID").append(", ");
        buffer.append("MG_TD_REPLY_TO").append(", ");
        buffer.append("MG_TD_TYPE").append(", ");
        buffer.append("MG_TD_BROKER_NAME").append(", ");
        buffer.append("MG_TD_NAME").append(", ");
        buffer.append("MG_TD_CONNECTION_ID").append(", ");
        buffer.append("MG_REPLY_TO").append(", ");
        buffer.append("MG_DELIVERY_MODE").append(", ");
        buffer.append("MG_TYPE").append(", ");
        buffer.append("MG_PRIORITY").append(", ");
        buffer.append("MG_EXPIRATION").append(", ");
        buffer.append("MG_TIMESTAMP").append(", ");
        buffer.append("MG_SCHEDULE").append(", ");
        buffer.append("MG_REDELIVERY_LIMIT").append(", ");
        buffer.append("MG_HAS_LONG_USER_PROPS").append(", ");
        buffer.append("MG_USER_PROPERTIES").append(", ");
        buffer.append("MG_LIFECYCLE").append(", ");
        buffer.append("MG_CONTENT_LENGTH").append(", ");
        buffer.append("MG_CONTENT").append(", ");
        buffer.append("MG_VERSION").append(")");
        buffer.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return buffer.toString();
    }

    protected String getBlobSQL() {
        if (BLOB_SQL == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT ").append("MG_CONTENT").append(" FROM ");
            buffer.append(this.storage.getMessageTableName()).append(" WHERE ");
            buffer.append("MG_ID").append("=? FOR  UPDATE ");
            BLOB_SQL = buffer.toString();
        }
        return BLOB_SQL;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] preBlob(Connection connection) throws Exception {
        DatabasePlatform platform = this.storage.getDatabasePlatform();
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.message.getId());
            stmt.setLong(2, this.destinationId);
            stmt.setByte(3, this.message.getMessageType());
            MessageID msgID = this.message.getMessageID();
            stmt.setByte(4, (byte)(msgID.getStatus() | 1));
            stmt.setShort(5, msgID.getBrokerID());
            stmt.setLong(6, msgID.getEntryID());
            stmt.setInt(7, msgID.getConnectionID());
            stmt.setInt(8, msgID.getSequenceNumber());
            stmt.setInt(9, this.message.getMetaInfo());
            stmt.setString(10, this.message.getJMSCorrelationID());
            DestinationIdentity identity = (DestinationIdentity)this.message.getJMSReplyTo();
            if (identity != null) {
                byte type = identity.getType();
                if (type == 113 || type == 116) {
                    stmt.setLong(11, identity.getTemporaryID());
                    stmt.setByte(12, identity.getType());
                    stmt.setString(13, identity.getBrokerName());
                    stmt.setString(14, identity.getLocalName());
                    stmt.setInt(15, identity.getTemporaryConnectionID());
                    stmt.setNull(16, platform.getSqlType(Long.class));
                } else {
                    long id = DestinationUtil.getDestinationId(identity);
                    stmt.setNull(11, platform.getSqlType(Long.class));
                    stmt.setByte(12, (byte)120);
                    stmt.setString(13, null);
                    stmt.setString(14, null);
                    stmt.setInt(15, -1);
                    stmt.setLong(16, id);
                }
            } else {
                stmt.setNull(11, platform.getSqlType(Long.class));
                stmt.setByte(12, (byte)120);
                stmt.setString(13, null);
                stmt.setString(14, null);
                stmt.setInt(15, -1);
                stmt.setNull(16, platform.getSqlType(Long.class));
            }
            stmt.setInt(17, this.message.getJMSDeliveryMode());
            stmt.setString(18, this.message.getJMSType());
            stmt.setInt(19, this.message.getJMSPriority());
            stmt.setLong(20, this.message.getJMSExpiration());
            stmt.setLong(21, this.message.getJMSTimestamp());
            stmt.setLong(22, this.message.getScheduledTime());
            stmt.setInt(23, this.message.getRedeliveryLimit());
            if (this.message.hasUserProperties()) {
                this.hasLongProps = true;
                stmt.setBoolean(24, true);
                stmt.setString(25, null);
            } else {
                stmt.setBoolean(24, false);
                stmt.setString(25, null);
            }
            stmt.setByte(26, this.lifeCycle);
            byte[] data = this.getBlobData();
            stmt.setInt(27, data.length);
            this.getDatabasePlatform().setEmptyBlob(stmt, 28);
            stmt.setLong(29, this.version);
            int rows = stmt.executeUpdate();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5321_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5321_LEVEL, JeusMessage_JMS5._5321, new Integer(rows));
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            stmt.close();
        }
    }

    private String createUserProperties(MessageProperty properties) {
        StringBuffer buffer = new StringBuffer();
        DataSqueezer squeezer = this.storage.getDataSqueezer();
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            buffer.append(squeezer.squeeze(name));
            buffer.append(',');
            buffer.append(squeezer.squeeze(value));
            if (!i.hasNext()) continue;
            buffer.append(":");
        }
        return buffer.toString();
    }

    protected PreparedStatement prepareBlobStatement(Connection connection, PreparedStatement stmt, byte[] data) throws Exception {
        stmt.setLong(1, this.message.getId());
        return stmt;
    }

    protected String getBlobColumnName() {
        return "MG_CONTENT";
    }

    private byte[] getBlobData() throws IOException {
        ByteBufferWrapper buffer = this.message.getContent();
        return buffer.compactArray();
    }

    protected void postBlob(Connection connection) throws Exception {
        if (this.hasLongProps) {
            MessageProperty property = this.message.getProperties();
            InsertUserPropertiesCommand command = new InsertUserPropertiesCommand(this.storage, this.message.getId(), property);
            if (NEED_LOGGING) {
                command.log();
            }
            command.execute(connection);
        }
    }
}

