/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.util.Iterator;
import java.util.logging.Level;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public abstract class LoopSQLCommand
extends SimpleSQLCommand {
    private static final boolean NEED_LOGGING = logger.isLoggable(Level.FINEST);

    public LoopSQLCommand(DatabaseStorage storage) {
        super(storage);
    }

    public void execute(Connection connection) throws Exception {
        Iterator i = this.getIterator(connection);
        while (i.hasNext()) {
            Object item = i.next();
            SQLCommand command = this.getSQLCommand(connection, item);
            if (command.isSynchronous()) {
                if (NEED_LOGGING) {
                    command.log();
                }
                command.execute(connection);
                continue;
            }
            this.storage.execute(command);
        }
    }

    protected abstract SQLCommand getSQLCommand(Connection var1, Object var2) throws Exception;

    protected abstract Iterator getIterator(Connection var1) throws Exception;
}

