/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class MakeDestinationInvalidCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "MAKE_DESTINATION_INVALID";
    private long id;
    private long version;

    public MakeDestinationInvalidCommand(DatabaseStorage storage, long id) {
        super(storage);
        this.id = id;
        this.version = System.currentTimeMillis();
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getDestinationTableName()).append(" SET ");
        buffer.append("DT_VALID").append("=?,");
        buffer.append("DT_VERSION").append("=?");
        buffer.append(" WHERE ").append("DT_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_VALID", String.valueOf(false)), new SQLParameter("DT_VERSION", String.valueOf(this.version)), new SQLParameter("DT_ID", String.valueOf(this.id))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setBoolean(1, false);
            stmt.setLong(2, this.version);
            stmt.setLong(3, this.id);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

