/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class PreparedXACommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "PREPARED_XA_COMMAND";
    private JMSXid xid;

    public PreparedXACommand(DatabaseStorage storage, JMSXid xid) {
        super(storage);
        this.xid = xid;
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("XA_ID", String.valueOf(this.xid.hashCode())), new SQLParameter("XA_PREPARED", String.valueOf(true)), new SQLParameter("XA_XID", this.xid.toString())};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setBoolean(1, true);
            stmt.setInt(2, this.xid.hashCode());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(this.storage.getXATableName()).append(" SET ");
        buffer.append("XA_PREPARED").append("=? ");
        buffer.append(" WHERE ").append("XA_ID").append("=?");
        return buffer.toString();
    }
}

