/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class PreparingXACommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "PREPARING_XA_COMMAND";
    private JMSXid xid;

    public PreparingXACommand(DatabaseStorage storage, JMSXid xid) {
        super(storage);
        this.xid = xid;
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("XA_ID", String.valueOf(this.xid.hashCode())), new SQLParameter("XA_PREPARED", String.valueOf(false)), new SQLParameter("XA_XID", this.xid.toString())};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setInt(1, this.xid.hashCode());
            stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stmt.setBoolean(3, false);
            stmt.setBytes(4, this.xid.toByteArray());
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(this.storage.getXATableName()).append("(");
        buffer.append("XA_ID").append(", ");
        buffer.append("XA_STARTTIME").append(", ");
        buffer.append("XA_PREPARED").append(", ");
        buffer.append("XA_XID").append(")");
        buffer.append(" VALUES (?, ?, ?, ?)");
        return buffer.toString();
    }
}

